/* file: 5000spel.h 
 * door: Arnold Metselaar
 *
 * programma voor het 5000-spel (zie MCCM 83)
 * definities en prototypes
 */

#define FAST char
#define UFAST unsigned char
#define uint unsigned int
#define ulong unsigned long

/* constanten in het spelletje,
   scores worden gedeeld door 50: */
#define SC 50
#define BAKLIM 3
#define W_STRAAT 30
#define W_3_PAAR 20
#define W_3_PIK  20
#define W_PIK  2
#define W_VIJF  1
#define WINLIM  100
#define SCHRLIM 10
#define MINBAK (5*W_VIJF+W_PIK)
#define MAXBAK (W_3_PIK+6*W_PIK)

#define FAC 6000 /* factor voor verw_beurt() */

/* opslag voor mogelijke voortzettingen: */
struct tak
{
  char Worp[7];
  uint Kansen;
} ;
/* vooraf berekende data (boom.as) */
extern uint ntak[6];
extern uint ntot[6];
extern struct tak * boom[6];
extern uint stapel[];

/* vooraf berekende verwachtingswaarden (tabmain.as) */
extern uint tabmain[];
extern uint RestB[WINLIM];

extern ulong teller;
extern int klepnivo;

/* algemene functies: */
extern void *xalloc(uint);
extern char *doe_worp(char*, UFAST); 
extern FAST deel_van(char*, char*);
extern void sub_str(char *geheel, char *deel, FAST index);
extern FAST sub_str_test(char *geheel, char *deel, FAST index);
extern FAST waarde(char*, char*);

/* for playable game */
extern UFAST beurt (char *, UFAST, UFAST);

/* beslissende functies */
extern FAST doorgaan(char*,char*,char*,UFAST,UFAST,UFAST);
extern char extra_gok(char);

/* waar het om gaat: rekenen ! */
extern uint verw_beurt(char*, UFAST, UFAST, UFAST, uint);
extern uint macht(uint, uint);
extern int mapmain(UFAST,UFAST);

