/* file: 5000verw.c 
 * door: Arnold Metselaar
 * 
 * programma voor het 5000-spel (zie MCCM 83)
 * bereken verwachtingswaarden en andere zaken
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "5000spel.h"

#define C_NIKS 0
#define C_XXX  1
#define C_EG   2

/* in deze file : */
uint verw_beurt(char*, UFAST, UFAST, UFAST, uint);
uint macht(uint,uint);

  /* index van werkruimte voor verw_beurt:  */
int top; 

#ifdef DEMO  
/* statistiek: tel aanroepen van verw_beurt */
ulong teller;
#endif

/* bereken (FAC maal) de verwachtingswaarde van 
   het aantal beurten nodig na deze beurt, met keuze of men doorgooit.
   vereist: totsc<=WINLIM-SCHRLIM, totsc+brtsc< WINLIM. 
   Als max geen nul is, dan zal de functie msx teruggeven 
   zodra duidelijk is dat de waarde grote/gelijk max wordt. */
uint verw_beurt(char *bak, UFAST totsc, UFAST brtsc, UFAST vb, uint max)
{ 
  char c,*p;
  int u,w;
  ulong som;
  struct tak *stam;
  uint *score, scx4, scx5;
  UFAST l,tbrt;
  FAST t;
  FAST may_stop;
  uint zesmachtw;
  ulong max_som;
  char temp[7];

#ifdef DEMO
  teller++;
#endif DEMO
  if ((l=strlen(bak))==6)
    return tabmain [mapmain(totsc,brtsc)];

  c=bak[0];
  som=0;
  for (p=bak, t=0 ; *p ; p++) t+=((*p==c)?1:-7);
  if ((c!='1')&&(c!='5')) {
    switch(t) {
        case 5: som=(long)144*RestB[totsc]; break; /* geen keus meer */
        case 4: som=(long)190*RestB[totsc]; break; /* hier ook niet */
        case 3: c=C_XXX; 
		/* bij de volgende worp kan evt. gegokt worden op sextet */
	        scx4=(long)190*RestB[totsc]/216; /* 'score' bij xxxx */
		scx5=(long)144*RestB[totsc]/216; /* 'score' bij xxxxx */
		break;
      default : c=C_NIKS; break;
      }
    if (som) return som/216;
  }
  else {
    c=(t==5)? C_EG : C_NIKS;
  }
  may_stop = (brtsc>=SCHRLIM) && (l || (vb>=BAKLIM));
  zesmachtw = ntot[l];
  if (may_stop || (0!= max))
  {
      if ((0 == max) || (may_stop && (RestB[totsc+brtsc] < max)))
	max = RestB[totsc+brtsc];
      max_som = (ulong) max * zesmachtw;
      may_stop = 1;
      if (C_EG == c) max_som += RestB[totsc];
  }

  score=&(stapel[top]); top+=ntak[l];
  stam=boom[l];

  for (u=0 ; u<ntak[l] ; u++) {
    if ( (t=waarde(stam[u].Worp,bak)) >=0 ) {
      tbrt=(UFAST) t+brtsc; 
      score[u]=(tbrt+totsc < WINLIM)
	       ? verw_beurt( strcat(strcpy(temp,bak),stam[u].Worp), 
			     totsc, tbrt, vb, 0)
               : 0 ;
    }
    else score[u]=RestB[totsc];
    /* Corrigeren voor de mogelijkheid sommige stenen niet te gebruiken */
    for (w=0; w<u ; w++)
      if ( (score[w]<score[u]) && deel_van(stam[w].Worp,stam[u].Worp) )
	score[u]=score[w];

    som+=(ulong) score[u]*stam[u].Kansen ;

    /* overweeg evt. doorgokken als bak = xxx: */
    if ((c==C_XXX) && ( (w=strlen(stam[u].Worp)) < 3))
    {  
      /* mogelijkheden voor 1 x in (3-w) stenen <> 1,5 */
      static UFAST kx4[3]={  27,  6, 1 }; 
      /* mogelijkheden voor 2 x in (3-w) stenen <> 1,5 */
      static UFAST kx5[3]={   9,  1, 0 }; 
      /* mogelijkheden voor (3-w) stenen zonder afzonderlijke waarde */
      static UFAST nxn[3]={64-4, 16, 4 }; 
    
      /* deze correctie moet direct op som omdat score[u] de verwachtingswaarde
	 van het aantal beurten na deze bij voortzetting met stam[u].Worp of
         een deel daarvan is. Bij veranderen van score[u] zou de correctie 
	 hieronder leiden tot een valse correctie van de score van een Worp met
	 meer enen en vijven hierboven */
         
      if (scx5<score[u]) 
	som-=(ulong)(score[u]-scx5)*(stam[u].Kansen*kx5[w]/nxn[w]);
      if (scx4<score[u]) 
	som-=(ulong)(score[u]-scx4)*(stam[u].Kansen*kx4[w]/nxn[w]);
    }
    if (may_stop && (som >= max_som)) 
      break; 
  }

  if (may_stop && (som >= max_som))
      u = max;
  else
  {
      if (c == C_EG) som-=score[0]-0; /* correctie bij extra gok */ 
      u=som/zesmachtw;
  }
  top-=ntak[l];
  return u;
}

#ifdef DEMO
/* geef de plaats van verw_beurt ("",t,b,v) in tabel[v], 
   nodig om het gegeugen efficint te gebruiken. 
int mapping(UFAST t, UFAST b, UFAST v)
{
  int l,k;

  if (v>=BAKLIM) 
  {
    l=WINLIM-BAKLIM*MINBAK+1;
    k=t;
    v=BAKLIM;
  }
  else
  {
    l=v*(MAXBAK-MINBAK)+1;
    k=(t>(WINLIM-v*MAXBAK))?t-(WINLIM-v*MAXBAK):0;
  }
  return l*t -k*(k+1)/2 + b-v*MINBAK;
}
*/  
  /* x tot de macht y */
uint macht(uint x,uint y)
{
  uint res;

  res=1;
  while (y) {
    if (y&1) 
      { res*=x; --y; }
    else 
      { x*=x; y>>=1; }
  }	
  return res; 
}
#endif
