/* beurt.c 
 * do one turn in the 5000 game
 */

#include <bglib.h>
#include <string.h>

#include "5000spel.h"
#include "design.h"

extern char waitchar();
extern void pause();
extern char machine[];

char prevnext[] = "PREV  NEXT";
char roll[] = "ROLL";
char add[] = "ADD";
char blank[] = "    "; 
/* 1..6 on azerty keyboard without shift: */
char az_digit[] = { '&', 0x82, '"', '\'', '(', 0xBF, 0};

/* Azerty keyboards normally need shift to type digits,
   translate shiftless keypresses to digits. */
char az_decode(char c)
{
  char *p;
  p = strchr(az_digit, c);
  if ( NULL != p)
  {
    c = p - az_digit + '1';
  }
  return c;
}

void show_die(UFAST x, UFAST y, char w)
{
  UFAST o;
  if (' ' == w)
  {
    for (o=y ; o< y+3 ; o++)
    {
      locate(x,o  ); _puts(blank); 
    }
  }                          
  else
  {
    o = w-'0';
    locate(x,y  ); _puts(die_top+(o/2)*5); 
    locate(x,y+1); _puts(die_mid+(o&1)*5); 
    locate(x,y+2); _puts(die_bot+(o/2)*5); 
  }
}

char guess(char w)
{
  FAST i;
  char in, uit;
  locate(0,STATLN);
  printf(" Lucky guess counts as %c.\n Please make a guess.",w-'1'+0xF0);
  locate(PREVCOL, BOTTOM);
  _puts(prevnext);
  for (i=0 ; i<6 ; i++) {
    uit = '1'+i;
    if (w == uit)
      { uit = ' '; }
    show_die(2+ 5*i, WORPLN, uit);
    locate(3+5*i, NUMLN);
    putchar(uit);
  }
  uit = ' ';
  do {
    in = waitchar();
    switch(in) {
      case 'r':
      case 'R':
      case ' ':
      case '\r':
      case 31: /* down */
	if (' ' != uit) in = 0;
	break;
      case 'p':
      case 'P':
      case 29: /* left */
	uit = (' ' == uit) ? w : uit;
        do {
          uit = ((uit - '1' + 5) % 6) + '1';
	} while (w == uit); 
       break;
      case 'n':
      case 'N':
      case 28: /* right */
	uit = (' ' == uit) ? w : uit;
        do {
          uit = ((uit - '1' + 1) % 6) + '1';
	} while (w == uit); 
       break;
      default:
        in = az_decode(in);
	if (('1' <= in) && (in <= '6')) {
	  uit = in;
	}
	break;
    }
    if (' ' != uit)
    {
      show_die(GOKCOL+1, GOKLN+2, uit);
      locate (ROLLCOL, BOTTOM);
      _puts(roll);
    }
  } while (in); 
  for (i=0 ; ; i++) {
    show_die(2+ 5*i, WORPLN, ' ');
    locate(3+5*i, NUMLN);
    if (i == 5)
      { putchar('6'); break; }
    else  
      { _puts("W"); }
  }
  locate(0,STATLN);
  _puts("\t\t\t \n\t\t\t");
  return uit;
}

void update(UFAST uit, char * worp, FAST nmask, FAST omask, FAST val);

UFAST next(UFAST omask, char* worp, char * bak, char * zet_uit, FAST dir)
{
  UFAST uit, mask, mx;
  FAST val;

  uit = strlen(bak);
  mx = 1 << (6-uit);
  val = -1;
  mask = omask;
  while ( -1 == val)
  {
    mask = (mask + mx + dir) % mx;
      
    if (sub_str_test(worp, zet_uit, mask))
    {
      val = waarde(zet_uit, bak);
    } 
  }
  update(uit, worp, mask, omask, val);
  return mask;
}

FAST hasval(char* worp, char* bak)
{
  UFAST uit, mask, mx;
  FAST val;
  char zet_uit[7];

  uit = strlen(bak);
  mx = 1 << (6-uit);
  for (mask = 1, val = -1 ; mask < mx ; mask++)
  {
    if (sub_str_test(worp, zet_uit, mask))
    {
      val = waarde(zet_uit, bak);
      if (val >=0) { return 1; }
    } 
  }
  return 0;
} 

FAST select(char * bak, char * worp, char * zet_uit, 
	    UFAST tsc, UFAST bsc, UFAST vb)
{
  UFAST uit, mask, x, mx;
  FAST val, may_end, res, done;
  char in, w;

  mask = 0;
  zet_uit[0]='\0';
  /* locate(0,TASKLN); */
  if (!hasval(worp,bak))
  {
    _puts(" No more moves\n Please press a key.");
    locate(0, BOTTOM);
    _puts(eraseline);
    res=0;
    waitchar();
  }
  else
  {
    uit = strlen(bak);
    _puts("\n Please select dice.");
    locate(PREVCOL, BOTTOM);
    _puts(prevnext);
    done = 0;
    while (! done)
    {
      val = waarde(zet_uit, bak);
      locate(VALCOL, VALLN);
      if (val < 0) { 
	_puts("   -");
	locate(ROLLCOL, BOTTOM); 
	_puts(blank);
	may_end = 0;
      }
      else { 
	printf("%4u", val*SC); 
	locate (ROLLCOL, BOTTOM);
	_puts(roll);
	may_end = (val > 0) && (bsc+val >= SCHRLIM);
	if  ((6 == strlen(zet_uit)+uit) && (vb < 2) && (tsc+bsc+val < WINLIM))
	  may_end = 0;
      }
      locate (ADDCOL, BOTTOM);
      _puts(may_end ? add : blank);

      in = waitchar();
      switch (in)
      {
      case 'a':
      case 'A':
      case 30: /* up */
	if (may_end) { res = 0 ; done = 1; }
	break;	
      case 'r':
      case 'R':
      case 31: /* down */
	if (val >= 0) { res = 0x80 ; done = 1; }
	break;
      case 'p':
      case 'P':
      case 29: /* left */
	mask = next(mask, worp, bak, zet_uit, -1);
        break;
      case 'n':
      case 'N':
      case 28: /* right */
        mask = next(mask, worp, bak, zet_uit, 1);
        break;
      default:
        in = az_decode(in);
	if ( (in > uit+'0') && (in <= '6')) 
	{
	  x = in-'1'-uit;
	  w = worp[x];
	  mx = 1 << x;
	  mask ^= mx;
	  x = 2 + 5*(uit+x);
	  if (mask & mx)
	  {
	     show_die(x, WORPLN, ' ');
	     show_die(x, BAKLN, w);
	  }
	  else
	  {
	     show_die(x, BAKLN, ' ');
	     show_die(x, WORPLN, w);
	  }
          sub_str(worp, zet_uit, mask);
	} /* if (in valid number) */	
	break;
      } /* switch */	
    } /* while (!done) */
    res |= mask; 
  }
  locate (0, BOTTOM);
  _puts(eraseline);
  return res;
}

void update(UFAST uit, char * worp, FAST nmask, FAST omask, FAST val)
{
  UFAST x,mx;
  FAST dmask;
  char *p;

  dmask = nmask ^ omask;
  x = 2 + 5*(uit);
  for (mx = 1, p = worp; mx <= dmask ; p++, mx <<= 1, x+=5)
  {
    if (mx & dmask)
    {
      if (mx & nmask)
      {
         show_die(x, WORPLN, ' ');
         show_die(x, BAKLN, *p);
      }
      else
      {
         show_die(x, BAKLN, ' ');
         show_die(x, WORPLN, *p);
      }
    }
  }
  locate(VALCOL, VALLN);
  printf("%4d", val * SC);
}

void show_worp(UFAST uit, char * worp)
{
  UFAST i,x;
  x= 2 + 5*uit;
  for (i = 0 ; i < 6-uit ; i++, x+=5)
  {
    show_die(x, WORPLN, worp[i]); 
  }
}

void show_keep(UFAST uit, char * worp, UFAST mask)
{
  UFAST from, to;
  UFAST mx;
  register char * p;
  char *bar;

  from = to = 2 + 5*uit;
  bar = "  WWW";
  p = worp;
  for (mx = 1 ; mx <= mask ; mx <<= 1, from += 5, p++) {
    if (mx & mask) {
	if (to < from) {
	  /* TODO: smoothly move dice */
	  show_die(from, BAKLN, ' ');
	  show_die(to, BAKLN, *p);
    	}
	locate(to-2, NUMLN);
	_puts(bar);
	bar =  "WWWWW";
	to += 5;
    }
    else {
	show_die(from, WORPLN, ' ');
    }
  }
  while (from < 32) {
    show_die(from, WORPLN, ' ');
    from +=5;
  } 
}

char erase3lines[] = {
27, 'K', '\n', 
27, 'K', '\n', 
27, 'K', '\0' 
} ;

char check_gok(char * bak, FAST mac)
{
  char gok;
  UFAST x;

  for ( x=1 ; bak[0] == bak[x] ; x++)
	  ;
  if (5 == x)
    {
       locate(GOKCOL,GOKLN); _puts("lucky");
       locate(GOKCOL,GOKLN+1); _puts("guess");
       gok = mac ? extra_gok(bak[0]) : guess(bak[0]);
       show_die(GOKCOL+1,GOKLN+2, gok); 
    }
  else
    gok = '-';
  return gok;
}

void vollebak(UFAST vb)
{
  switch (vb)
  {
     case 1: _puts("First"); break;
     case 2: _puts("Second"); break;
     case 3: _puts("Third"); break;
     default: _puts("Yet another"); break;
  }
  _puts(" bar complete.");
  pause(); 
  locate(0, STATLN); 
  _puts(eraseline);
}

UFAST beurt (char * name, UFAST turn, UFAST totsc)
{
  UFAST bsc, vb, uit, door; 
  FAST val, mac;
  char gok;
  char bak[7], worp[7], keep[7];

  bsc = vb = 0;
  locate (0,8);
  printf("%cJ %s's turn", 27, name);
  locate (0,VALLN-1);
  printf(" turn points  value\n %3d       0\t\t", turn);
  mac = (0 == strncmp(name, machine, 7)); 

  door = 1; val = 0;
  gok = '-'; 
  while  (door)
  {
    bak[0] = '\0';
    uit = 0;
    locate(0,BAKLN);
    _puts(erase3lines);
    locate(2, NUMLN);
    _puts(" 1    2    3    4    5    6 ");
    while ((uit < 6) && door)
    {
      if (5 == uit)
	gok = check_gok(bak, mac);
      doe_worp(worp, 6-uit);
      show_worp(uit, worp);
      locate(0, STATLN);
      if ('-' != gok)
      {
	if (gok == worp[0]) {
	  printf(" Note: %c counts as %c", gok-'1'+0xF0, bak[0]-'1'+0xF0);
	  worp[0] = bak[0];
	}
	else if (bak[0] != worp[0])
	  _puts(" Bad luck! ");
	if (mac) pause();
      }
      if (mac) door = doorgaan (bak, worp, keep, totsc, bsc, vb);
      else door = select(bak, worp, keep, totsc, bsc, vb);
      val = waarde(keep, bak);
      if (val < 0)
      {
	door = 0;
      }
      else
      {
	show_keep(uit, worp, door & 0x7F);
        strcpy(bak+uit, keep);
        uit += strlen(keep);
	bsc += val;
	locate(7, VALLN);
	printf("%5d       ", bsc*SC);
	door &= 0x80;
      }
    } /* while ( (uit < 6) ... */
    if ('-' != gok)
    {
      show_die(GOKCOL+1, GOKLN+2, ' ');
      gok = '-';
    }
    locate (0, STATLN);
    _puts(erase2lines);
    locate (1, STATLN);
    if (!door)
    {                                                             
      if (bsc >= SCHRLIM)
        printf("%d points %s.", bsc*SC, 
		(val<0) ? "down the drain" : "added to the score");
      else
	_puts(" No points scored.");
    }
    else 
    { 
      vollebak(++vb);
    }
  } /* while (door) */
  
  return (val<0) ? 0 : bsc;
}

