/* game.c
 * main fuction for playing 5000 game human versus computer 
 */

#include <bglibio.h> 
#include <bglib.h>
#include <string.h>

#include "5000spel.h"
#include "design.h"

extern void bord();
extern char title();
extern char names[3][11];
extern char human[];
extern char machine[];

UFAST points[3][3];
int klepnivo = 0;

#define FNKSTR ((char*)0xF87F)

static char *keydef[5] =
{ "h", "p", "n", "r", "a" };

void fkeys()
{
  UFAST i;
  for (i=0 ; i <10 ; ++i) {
    strcpy(FNKSTR + i*16, keydef[i%5]);
  }
}

#define JIFFY (*((uint*)0xFC9E))

int extchar()
{
  static int stick_char[] = { EOF, 30, 28,28,28, 31, 29,29,29 }; 
  static char ostick[2];
  static char ostrig[5];
  UFAST i, nw;
  int res;

  res = EOF;

  for (i = 1 ; i < 3 && EOF ==res ; ++i)
  {
    nw = stick(i);
    if (nw != ostick[i])
    {
       res = stick_char[nw];
       ostick[i] = nw;
    }
  } 
  for (i = 1 ; i < 5 && EOF == res ; ++i)  
  {
    nw = strig(i);
    if (nw != ostrig[i] && nw != 0)
    {
      res = ' ';
    }
    ostrig[i] = nw;
  }
  if (EOF == res)
  {
    res = getchar();
  }
  return res;
}

void pause()
{
  uint last;
  int in;
  last = JIFFY + 120;
  do {
    in = extchar();
  } while ((EOF == in) && (JIFFY != last));
}

char waitchar()
{
  int c;
  do {
    c = extchar();
  } while (EOF == c);
 return c;
}

void show_score (UFAST p, UFAST y)
{
   locate(2+11*p, 4+y);
   printf("%5u", SC*points[p][y]);
}

/* shift the scores on the score board */
void shift()
{
  UFAST p,y;

  for (y=0 ; y<2 ; y++)
  {
    for (p=0 ; p<3  ; p++)
    {
      if (0 != names[p][0]) {
	points[p][y]=points[p][y+1];
	show_score(p,y);
      }
    }
  }
  for (p=0 ; p < 3 ; p++)
  {
    locate(2 + 11*p, 4+2);
    printf("     "); 
  }
}

void game()
{
  UFAST turn, y, player, done;

  bord();
  y = done = 0;
  turn = 1;
  while (!done)
  {
     if (3 == y)
     {
	shift();
	y--;
     }
     for (player = 0 ; (player < 3) && ! done ; player++) 
     {
	UFAST totsc;
	if (0 == names[player][0])
	  continue;
	totsc = (y > 0) ? points[player][y-1] : 0;
	totsc += beurt(names[player], turn, totsc);
	points[player][y] = totsc;
        show_score(player, y);
        if (totsc >= WINLIM) {
	  done = 1;
	  locate(1, TASKLN);
	  _puts(eraseline);
	  printf("The winner is %s!", names[player]);
	  waitchar();
	}
	else pause();
     }
     turn++;
     y++;
  }
}

void main(int argc, char ** argv)
{
  strcpy(names[0], human);
  strcpy(names[1], "");
  strcpy(names[2], machine);
  fkeys();
  color (15,4,2);
  screen(1);  c_linlen = 32; /* width(32); */
  charset();
  while ( title() ) {
    game();
  }
  screen(0);
}
