; rom header

psect header
defb 'A', 'B'
defw init
defw 0 ; no statement (CALL) 
defw 0 ; no device
defw 0 ; no basic text
defw 0,0,0 ; reserved

; allow starting from msx-dos
ld hl,(ENASLT+1) ; dos has routine that can switch page 0 to RAM, BIOS hasn't
push hl
global __Hdata
ld de, __Hdata - 1
ld hl, __Hdata - 1  - ( 4000h - 100h )
ld bc, __Hdata - 4010h
lddr
jp 0f
0:
ld a, (EXPTBL)
call ENASLT
ld a, ret
ld (loop_end),a
call from_dos
ld a,(RAMAD0)
ld h,0
ret ; switch page 0 back to RAM and return to DOS

; put this here to keep it safe to execute defw init
startup:
global _main, __Hbss, __Lbss, __Sbss
ld a,(HOOK+1)
ld h,80h
call ENASLT
ld a,(MSXVER)
cp 3
jp c, loop
ld a, 82h ; R800+DRAM
call CHGCPU

loop:
ld hl, __Hbss+0800h ; require 2 kiB for stack+heap
ld de,(STKTOP)
or a
sbc hl,de
jr c, 1f
ld de, 0f380h
1:
ex de,hl
ld sp,hl

from_dos:
ld hl,__Lbss
ld de,__Lbss+1
ld bc,__Sbss-1
ld (hl),0
ldir

ld de, argv
push de
ld de, 1
push de
call _main
pop bc
pop bc
loop_end:
jr loop 

; not really part of the header, but this must be in page 1 

BDOS   equ 0005h
ENASLT equ 0024h
MSXVER equ 002Dh
RSLREG equ 0138h
CHGCPU equ 0180h
EXPTBL equ 0FCC1h
SLTTBL equ 0FCC5h
HOOK   equ 0FEDAh
STKTOP equ 0F674h
RAMAD0 equ 0F341h

init:
call RSLREG
rra
rra
and 03h
ld b,a
ld h,.high. EXPTBL
add a,.low. EXPTBL
ld l,a
ld a,b
or (hl) ; can be 80h or 0
jp p, slotina
ld b,a
add a, +(.low. SLTTBL)-80h
ld l,a
ld a,(hl) 
and 0Ch
or b
slotina:
ld de,startup
ld hl,HOOK
ld (hl),0F7h ; rst 30h
inc hl
ld (hl),a
inc hl
ld (hl),e
inc hl
ld (hl),d
ret

psect data
arg0: 
defm 'ROM'
defb 0
argv:
defw arg0,0

psect pad
defb 01Ah
