; screen.as - adapted for use in memman tsr, bios rom must be in page 0

EXTROM	equ	015Fh

	MACRO	subrom,routine
	psect	text
	push	ix
	push	iy
	ld	ix,routine
	call	EXTROM
	ei
	pop	iy
	pop	ix
	ENDM

; void screen(mode)
; unsigned char mode;

CHGMOD	equ	005Fh			; for MSX1
CHGMDP	equ	01B5h			; for MSX2 (initialize palette also)
EXBRSA	equ	0FAF8h

        psect   text
	global	_screen,csv,cret

_screen:
	call	csv
        ld      c,(ix+6)                ; save screen mode
	ld	a,(EXBRSA)		; running on MSX1?
	and	a
	ld	a,c			; restore screen mode
	ld	(0fcafh),a		; scrmod
	jr	z,screen_msx1		; yes
	subrom	CHGMDP	         ; change screen mode and initialize
	jp	cret
screen_msx1:
	call    CHGMOD
	jp	cret

; void totext()

;       TOTEXT  forces the screen to text mode.

TOTEXT  equ     00D2h

        psect   text
        global  _totext

_totext equ TOTEXT

