/* title.c 
Title screen and entering competitors for 5000 game
design:
WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW
      5000 game by Arnold       
WWWWWWWWWWRWWWWWWWWWWRWWWWWWWWWW
  Human   V          V Machine 
          VV       
          V          V        
          V          V       
WWWWWWWWWWQWWWWWWWWWWQWWWWWWWWWW

Select middle player:

    Enter name     Human    
                  
    Machine player             
    
    No player                 
    

   1    2    3    4    5    6
  ###  ##o  ##o  o#o  o#o  ooo
  #o#  ###  #o#  ###  #o#  ###
  ###  o##  o##  o#o  o#o  ooo

                          START   
*/

#include <stdlib.h>
#include <bglibio.h> 
#include <bglib.h>
#include <string.h>

#include "5000spel.h"
#include "design.h"
extern char waitchar();

char names[3][11];

#define JIFFY (*((uint*)0xFC9E))

char hline[] = "WWWWWWWWWW"; /* 10 times 'W' */
char human[] = "Human"; 
char machine[] = "Machine"; 

void getname(UFAST player)
{
  char buffer[11];
  char * p;
  UFAST i, done;
  char c;

  memset(buffer, ' ', 10);
  buffer[10] = 0;
  if (0 == names[player][0] ||
	0 == strcmp(names[player], machine) )
  {
     strcpy(buffer, human);
  }
  else
  {
     strcpy(buffer, names[player]);
  }
  locate(19, STATLN+2);
  _puts(buffer);
  locate(19, STATLN+3);
  _puts("");
  
  done = i = 0;
  while (0 == done)
  {
    locate(19+i, STATLN+2);
    _puts("y5");
    c = waitchar();
    switch (c)
    {
    case 28: /* right */
      if (i < 10) ++i;
      break;
    case 29: /* left */
      if (i > 0) --i;
      break;
    case 13: /* return */
      p = buffer;
      while (' ' == *p)
      {	++p; }
      i = 0;
      while (*p)
      { 
	names[player][i++] = *p++; 
      }
      names[player][i] = 0;
      while( i > 0 && ' ' == names[player][--i])
      {
         names[player][i] = 0;
      }
    case 27: /* esc */
      puts("x5");
      done = 1;
      break;
    case 12: /* cls */
      memset(buffer,' ',10);
      _puts("x5");
      locate(19, STATLN+2);
      _puts(buffer);
    case 11: /* home */
      i = 0;
      break;
    case 8: /* backspace */
      if (0 == i)
      { break; }
      --i;
    case 127: /* delete */
      p = buffer + i;
      _puts("x5");
      while (p < buffer+10)
      {
        *p = p[1];
	if (*p)
        {
	  putchar(*p++);
        }
        else
        {
	  putchar(' ');
          break;
        }
      }
      break;
    default:
      if ( ( (unsigned char)c >= (unsigned char)' ' ) && (c != 127))
      {
	buffer[i] = c;
        putchar(c);
        if (i < 10) ++i;
      }
      break;
    }
  }

  locate(19, STATLN+2);
  _puts("K"); 
}

void putline(char x)
{
  _puts(hline);
  putchar(1); putchar(x);
  _puts(hline);
  putchar(1); putchar(x);
  _puts(hline);
}

char vline2[] = "          V          V"; /* 2 times 10 times ' ' */

void show_name(UFAST player)
{
    FAST l, i, t;
    locate(11*player, 3);

    l = strlen(names[player]);
    t = 0;
    i = (10-l)/2;
    while (t<i)
    {
      putchar(' ');
      t++;
    }
    _puts(names[player]);
    t += l;
    while(t<10)
    {
      putchar(' ');
      t++;
    }
}

void bord()
{
  UFAST player;

  cls();
  putline('W');
  puts("      LIMARIBU by Arnold");
  putline('R');
  puts(vline2);	
  puts(vline2);	
  puts(vline2);	
  puts(vline2);
  putline('Q');	
  for (player = 0 ; player < 3 ; player++)
  {
    show_name(player);
  }
}

extern void show_die(UFAST x, UFAST y, char w);

char title()
{
  uint seed, cnt;
  UFAST t, done, player;
  UFAST x, y;
  uint last;
  char in;

  puts("\f\n\n\n\t** LIMARIBU **");
  puts("\n* Press space or fire for menu *");
  /* get some entropy */
  done = 0;
  y = 0;
  x = 0;
  last = JIFFY+1;
  while (!done) 
  {
    if (JIFFY == last)
    {
       show_die(x, y,' ');
       x = 2 + rand() % 25;
       y = 8 + rand() % 12;
       show_die(x, y, '1' + (rand() % 6)); 
       last = JIFFY + 60;
    }
    cnt++;
    for (t=0 ; t < 5 ; t++)
    {
      if (strig(t)) { done = 1 ; break; }
    }
  }
  cnt *= 137;
  while (strig(t)) cnt++;
  kilbuf();
  bord();
  player = 0;
  locate(0, STATLN);
  puts("Select player\n");
  puts("    Enter name");
  puts("    ");    
  puts("    Machine player");
  puts("    ");    
  puts("    No player");
  puts("    ");    
  locate(ADDCOL-1, BOTTOM);
  _puts("START");
  done = 0;
  while(!done) {
    locate(11*player,4);
    _puts("");
    in = waitchar();
    switch(in)
    {
    case 'e':
    case 'E':
	getname(player);
	show_name(player);
	break;
    case 'm':
    case 'M':
	strcpy(names[player],  machine);
	show_name(player);
	break;
    case 'n':
    case 'N':
	names[player][0] = 0;
	show_name(player);
	break;
    case ' ':
    case 'a':
    case 's':
    case 'S':
	done = names[0][0];
	done |= names[1][0];
	done |= names[2][0];
	break;
    case 27: /* esc */
	return 0;
    case 28: /* right */
	if (player < 2) {
	  locate(11*player,4);
	  _puts("          ");
	  player++;
	}
	break;
    case 29: /* left */
	if (player > 0) {
	  locate(11*player,4);
	  _puts("          ");
	  player--;
	}
	break;
    }
  }

  srand(seed^cnt);
  return 1;
}

