/* remap.c */
/* ad hoc compressie voor tactische data 5000spel */

#include <stdio.h>
#include <assert.h>

#include "5000spel.h"
extern uint *tabel[BAKLIM];
extern uint RestB[WINLIM];

/* geef de plaats van verw_beurt ("",t,b,v(b)) in tabmain, 
   nodig om het gegeugen efficint te gebruiken. 
   v(b) = 
     * 1 als b < 2*MINBAK,
     * 3 als b > 2*MAXBAK,
     * 2 anders. 
*/ 
int mapmain(UFAST t, UFAST b)
{
  int l;

  if (t > WINLIM-SCHRLIM)
  { 
    t = WINLIM - SCHRLIM;
  }
  assert (b >= MINBAK);
  assert (t+b < WINLIM);
  if (0==t)
  {
    return b-MINBAK;
  }
  assert (t >= SCHRLIM);
  l=WINLIM-MINBAK;
  return 
    l*(t-SCHRLIM+1) - ( (t-1)*t/2 - -(SCHRLIM-1)*SCHRLIM/2 ) + b-MINBAK;
}

/* geef de plaats van verw_beurt("",t,b,1)-tabmain[mapmain(t,b)] in tabc1, 
   voor 2*MINBAK <= b <= MAXBAK.
   */
int mapc1(UFAST t, UFAST b)
{
  int k,l;
  if (t > WINLIM-SCHRLIM)
    {
      t = WINLIM -SCHRLIM;
    }
  assert (b >= 2*MINBAK);
  assert (b <= MAXBAK);
  assert (t+b < WINLIM);
  if (0==t)
    {
      return b - 2 *MINBAK;
    }
  l=(MAXBAK-2*MINBAK)+1;
  k=(t>(WINLIM-MAXBAK))?t-(WINLIM-MAXBAK):0;
  return l*(t-SCHRLIM+1) -k*(k+1)/2 + b-MINBAK;
}

/* geef de plaats van tabmain[mapmain(t,b)]-verw_beurt("",t,b,3) in tabc3, 
   voor 3*MINBAK <= b <= 2*MAXBAK.
   */
int mapc3(UFAST t, UFAST b)
{
  int k,l;
  if (t > WINLIM-SCHRLIM)
    {
      t = WINLIM -SCHRLIM;
    }
  assert (b >= 3*MINBAK);
  assert (b <= 2*MAXBAK);
  assert (t+b < WINLIM);
  if (0==t)
    {
      return b - 3 *MINBAK;
    }
  l=(2*MAXBAK-3*MINBAK)+1;
  k=(t>(WINLIM-MAXBAK))?t-(WINLIM-MAXBAK):0;
  return l*(t-SCHRLIM+1) -k*(k+1)/2 + b-3*MINBAK;
}

uint *tabmain, *tabc1 , *tabc3;

void remap()
{
  UFAST t,b;
  int lm, l1, l3, i;
  uint m, m1, m3;
  FILE * fp;
  
  lm=mapmain(WINLIM-SCHRLIM, SCHRLIM-1)+1;
  printf ("tabmain: %d\n", lm);
  tabmain = xalloc(lm*sizeof(uint));
  l1=mapc1(WINLIM-2*MINBAK-1, 2*MINBAK)+1;
  printf ("tabc1  : %d\n", l1);
  tabc1 = xalloc(l1*sizeof(uint));
  l3=mapc3(WINLIM-3*MINBAK-1, 3*MINBAK)+1;
  printf ("tabc3  : %d\n", l3);
  tabc3 = xalloc(l3*sizeof(uint));

  for (t=0 ; t <= WINLIM-SCHRLIM ; t += t?1:SCHRLIM)
    { 
      for (b = MINBAK ; (b < 2*MINBAK) && (t+b < WINLIM) ; b++)
	{
	  tabmain[mapmain(t,b)] = tabel[0][mapping(t,b,1)];
	}
      for (b = 2*MINBAK ; (b < 3*MINBAK) && (t+b < WINLIM) ; b++)
	{
	  tabmain[mapmain(t,b)] = m = tabel[1][mapping(t,b,2)];
	  tabc1[mapc1(t,b)] = tabel[0][mapping(t,b,1)]-m;
	}
      for (b = 3*MINBAK ; (b <= MAXBAK) && (t+b < WINLIM) ; b++)
	{
	  tabmain[mapmain(t,b)] = m = tabel[1][mapping(t,b,2)];
	  tabc1[mapc1(t,b)] = tabel[0][mapping(t,b,1)]-m;
	  tabc3[mapc3(t,b)] = m-tabel[2][mapping(t,b,3)];
	}
      for (b = MAXBAK+1 ; (b <= 2*MAXBAK) && (t+b < WINLIM) ; b++)
	{
	  tabmain[mapmain(t,b)] = m = tabel[1][mapping(t,b,2)];
	  tabc3[mapc3(t,b)] = m-tabel[2][mapping(t,b,3)];
	}
      for (b = 2*MAXBAK+1 ;  (t+b < WINLIM) ; b++)
	{
	  tabmain[mapmain(t,b)] = tabel[2][mapping(t,b,3)];
	}
    }
  for (i=0, m1=0 ; i < l1 ; i++)
    {
      if (tabc1[i] > m1) m1=tabc1[i];
    }
  printf ("Maximale waarde in tabc1: %d\n", m1);
  for (i=0, m3=0 ; i < l3 ; i++)
    {
      if (tabc3[i] > m3) m3=tabc3[i];
    }
  printf ("Maximale waarde in tabc3: %d\n", m3);
  if ((0 != m1) || (0 != m3))
    return;

  fp = fopen ("msx/tabmain.as", "wb");
  fprintf (fp, "; tabmain.as, generated by 5000spel\r\n\
psect data\r\n\
; uint tabmain[%d]={...};\r\n\
global _tabmain\r\n_tabmain:",lm);
  for (i=0 ; i < lm ; i++)
    {
      if ( 0 == (i%8))
	fputs("\r\ndefw ",fp);
      else
	fputc(',',fp);
      fprintf (fp," %u", tabmain[i]);
    }
  fprintf (fp,"\r\n\r\n;uint RestB[%u]={...};\r\n\
global _RestB\r\n_RestB:", WINLIM);
  for (i=0 ; i < WINLIM ; i++)
    {
      if ( 0 == (i%8))
	fputs("\r\ndefw ",fp);
      else
	fputc(',',fp);
      fprintf (fp," %u", RestB[i]);
    }

  fprintf ( fp, "\r\nend\r\n");
  fclose (fp);
}
