/* file: 5000init.c 
 * door: Arnold Metselaar
 * 
 * programma voor het 5000-spel (zie MCCM 83)
 * initialisatie voor het rekenwerk
 */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "5000spel.h"
#define	UINT_MAX	65535		/* unsigned int */

/* in deze file : */
void tact_init(void);
void tabellen(void);
char *addtostr(char*, int, char);
uint maak_tabel(UFAST);
void prtijd(ulong);

  /* opslag voor mogelijke voortzettingen: */
struct tak
{
  char Worp[7];
  uint Kansen;
} ;

int ntak[6];
uint ntot[6];
struct tak *boom[6];

  /* opslag voor vooraf uitgerekende waarden  van
     verw_beurt("",totsc,0,0)+FAC en
     verw_beurt("",totsc,brtsc,1 .. BAKLIM) */
uint RestB[WINLIM];
uint *tabel[BAKLIM];

  /* verw_beurt gebruikt dynamisch geheugen strict LIFO, dus kunnen  we
het beheer beter zelf dan met malloc/free, bij  HI-TECH  C  levert  dat
laatste zelfs een geheugentekort */

uint *stapel;
int top; 

/* test nieuw opslagschema voor tabellen. */
extern void remap(void);


/* zet mogelijke voortzettingen op in arrays */
void boom_init()

{
  UFAST t,tr,n1,n5;
  uint k,h,p,i; 
  uint som,n;
  struct tak *stam;
  char basis[7];
  uint f[7];

  f[0]=1;
  for ( t=1 ; t<=6 ; t++) 
  {
    f[t]=f[t-1]*t;
    som=n=0;
    stam=xalloc(200*sizeof(struct tak));
    for (n1=0 ; n1<=t ; n1++)
      for (n5=0 ; n5<=t-n1 ; n5++)
      {
        tr=t-n1-n5;
	basis[0]='\0';
	addtostr(addtostr(basis,n1,'1'),n5,'5');
	h=f[t]/(f[n1]*f[n5]);
        k=h/f[tr] * macht(4,tr);
	if (t==6)
	{
	  if ((n1==1)&&(n5==1)) k-=720;		/* correctie straat */
          if ( ((n1==0)||(n1==2)) && ((n5==0)||(n5==2)) ) 
	    k-=(n1==n5)?360:540;		/* correctie 3 paar */
        }
	for (p=3 ; p<=tr ; p++ )
	  k-=h/(f[p]*f[tr-p])*4*macht(3,tr-p);	/* correctie p-tallen */
        if (tr==6) k+=120;	       /* correctie 2 trio's */
        strcpy(stam[n].Worp,basis); 
	som+=(stam[n++].Kansen=k);
	for (p=3, k=0 ; p<=tr ; p++ )  /* sla worpen met p-tallen op */
        {
	  k+=h/(f[p]*f[tr-p])*macht(3,tr-p);
	  if ((p==3)&&(tr==6)) k-=60;  /* correctie 2 trio's */
	  if ((t==6)||(p==tr))
	  {
	    for (i=0 ; i<4 ; i++)
	    {
	      addtostr(strcpy(stam[n].Worp,basis),(t==6?p:3),"2346"[i]);
	      som+=(stam[n++].Kansen=k);
	    }
	    k=0;
	  }
	}
      }
    if (t==6)
    {
      static struct tak poker[5]= /* het `pokerelement' van 5000 */
      { {"xxyyzz",360},
	{"55yyzz",540},
	{"11yyzz",540},
	{"1155zz",360}, 
	{"123456",720} };

      for(p=0 ; p<3 ; p++)
	for(i=p ; i<3 ; i++)
	{
	  stam[n].Worp[0]='\0';
	  addtostr(addtostr(stam[n].Worp,3,"234"[p]),3,"346"[i]);
	  som+=(stam[n++].Kansen=20);
	}
      for (p=0 ; p<5 ; p++)
      {
	stam[n]=poker[p]; 
	som+=stam[n++].Kansen;
      }
    }
    boom[6-t]=realloc(stam,n*sizeof(struct tak));
    ntak[6-t]=n;
    if (som!=macht(6,t)) 
    {
      printf("som fout in tact_init, t=%d", (int)t); 
      exit (1);
    }
  }
}

/* sla vast de mogelijke voortzettingen 
   en verw_beurt("",b,0,0..BAKLIM) op: */
void tact_init(void)
{
  UFAST t;
  char c;
  uint i,j,n;
  FILE *fp;

  boom_init();
  /* schrijf data voortzettingen naar bestand voor msx versie */
  fp = fopen ("msx/boom.as","wb");
  fputs("; boom.as, generated by 5000spel\r\n\
psect data\r\n\
; int ntak[6]={...};\r\n\
global _ntak\r\n_ntak:\r\ndefw ",fp);
  for (i=0 ; i < 6 ; i++) 
    {
      if (0 != i) fputc(',', fp);
      fprintf(fp, " %d", ntak[i]);
    }
  fputs("\r\n\r\n; uint ntot[6] = {...};\r\n\
global _ntot\r\n_ntot:\r\ndefw ",fp);
  ntot[5] = 6;
  for (i=5 ; i ; i--)
      ntot[i-1] = 6*ntot[i];
  for (i=0 ; i < 6 ; i++) 
    {
      if (0 != i) fputc(',', fp);
      fprintf(fp, " %u", ntot[i]);
    }

  fputs("\r\n\r\n;struct tak * boom[6]={...};\r\n\
global _boom\r\n_boom:\r\n\
defw boom0, boom1, boom2, boom3, boom4, boom5\r\n",fp);
  for (j=0 ; j < 6 ; j++)
    {
      fprintf(fp, "boom%d:\r\n",j);
      for (i=0 ; i < ntak[j] ; i++)
	{
	  fputs("defb ",fp);
	  for (n=0 ; n<7 ; n++)
	    {
	      if (0!=n)	 fputc(',', fp);
	      c = boom[j][i].Worp[n];
	      if (isprint(c))
		fprintf(fp, " '%c'", c);
	      else
		fprintf(fp, " %d", c);
	    }
	  fprintf(fp,"\r\ndefw %u\r\n", boom[j][i].Kansen); 
	}
    }
  /* werkruimte voor verw_beurt: */
  for(n=t=0; t<6; ) n+=ntak[t++];
  stapel=xalloc( n*sizeof(uint) );
  top=0; /* laagste vrije element */
  fprintf(fp, "\r\npsect bss\r\n\
; uint stapel[%u];\r\n\
global _stapel\r\n_stapel: defs 2*%u\r\n", n, n);
  fputs("\r\nend\r\n",fp);
  tabellen(); /* ruimte voor tabellen maken en vullen */
  remap();
  srand((uint)time(NULL)); /* initialiseer random */
}

/* maak tabellen aan met verwachtingswaarden  voor  het
   aantal beurten dat nog nodig is om uit te gooien */
void tabellen(void)
{
  uint f;
  uint x0, x1,x2, fx2, min,max;
  int gx0,gx1;
  UFAST t,u;
  ulong start;
  FILE * bestand;
  size_t tlen[BAKLIM];

  static char fnaam[]="5000tact.dat";

  for (t=0, f=MINBAK ; t<BAKLIM ; t++, f+=MINBAK ) /* f==(t+1)*MINBAK */
  {
    tlen[t]=mapping(WINLIM-f,f,t+1);
    tabel[t]=xalloc( tlen[t]*sizeof(uint) );
  }

  if ( (bestand=fopen(fnaam,"rb")) )
  {
    for (t=BAKLIM ; t-- ; )
      fread(tabel[t], tlen[t], sizeof(uint), bestand);
    fread(RestB, WINLIM, sizeof(uint), bestand);
    t=ferror(bestand);
    fclose(bestand);
    if (!t) return;
  }

  start=time(NULL);
  printf("%d: ", SC*(WINLIM-SCHRLIM));
  for (u=WINLIM-SCHRLIM ; u<WINLIM ; ) RestB[u++]=FAC;
  f=maak_tabel(WINLIM-SCHRLIM);
  fx2=(long)FAC*FAC/(2*FAC-f);
  do {
    x2=fx2;
    for (u=WINLIM-SCHRLIM ; u<WINLIM ; ) RestB[u++]=x2;
    printf("%u, ",x2);
    fx2=maak_tabel(WINLIM-SCHRLIM);
  } while (fx2!=x2);
  putchar('\n');

  for (t=WINLIM-SCHRLIM ; t-- ; )
  {
    printf("%d: ", SC*t);
    min=RestB[t+1];
    max=UINT_MAX;

/*                                     t
   extrapoleer RestB[t] als  at + b(-1)  + c : */
    RestB[t]=x2=RestB[t+1]+RestB[t+2]-RestB[t+3];
    fx2=maak_tabel(t);
    printf("(%u,%u) ",x2,fx2);
    x1=x2+2; gx1=fx2+1-x1; /* 1/2 is een goede gok voor de rico */
    while (fx2!=x2)
    {
      if (fx2>x2) min=fx2; else max=fx2; 
      x0=x1; gx0=gx1;
      x1=x2; gx1=fx2-x2;

      if (gx0!=gx1)
        x2=x1-(long)((long)gx1*((long)x1-x0))/((long)gx1-gx0);
      if ((x2<min) || (x2>max) || (x2==x1)) x2=fx2;
      RestB[t]=x2;
      fx2=maak_tabel(t);
      printf("(%u,%u)",x2,fx2);
    }
    putchar('\n');
  }
  prtijd(time(NULL)-start);
  puts("nodig gehad om de tabellen uit te rekenen.");

  if ( (bestand=fopen(fnaam,"wb")) )
  {
    for (t=BAKLIM ; t-- ; )
      fwrite(tabel[t], tlen[t], sizeof(uint), bestand);
    fwrite(RestB, WINLIM, sizeof(uint), bestand);
    t=ferror(bestand);
    fclose(bestand);
    if (t) puts("Schrijffout bij data-bestand.");
    else puts("Data-bestand geschreven.");
  }
}

/* vul tabel met verwachtingswaarden bij totsc */
uint maak_tabel(UFAST totsc) 
{
  UFAST brt,vb;
  uint *p;
  static char leeg[7]="";

  for (vb=BAKLIM ; vb ; vb--)
  {
    brt=WINLIM-totsc-1;
    if ((brt>vb*MAXBAK)&&(vb<BAKLIM)) brt=vb*MAXBAK;
    p=tabel[vb-1]+mapping(totsc,brt,vb);
    for ( ; brt>=vb*MINBAK ; brt--)
      *p--=verw_beurt(leeg, totsc, brt, vb);
  }
  return FAC+verw_beurt(leeg, totsc, 0, 0);
}

  /* voeg n keer karakter c aan *s toe: */
char *addtostr(char *s, int n, char c)
{ 
  char *p;

  for ( ; *s ; s++);
  for ( p=s ; p<s+n ; ) *p++=c;
  *p='\0';
  return s;
}

void prtijd(unsigned long t)
{ UFAST i;
  short int buffer[3];
  static int deler[3]={60,60,24};
  static char symb[3]={'s','m','h'};

  for (i=0; (t>0) && (i<3); i++)
  { buffer[i]= t % deler[i]; 
    t = t / deler[i];
  }
  if (t) printf(" %ldd",t);
  while (i--) printf(" %d%c",buffer[i],symb[i]);
}

