/* file: 5000spel.c 
 * door: Arnold Metselaar
 *
 * programma voor het 5000-spel (zie MCCM 83)
 * dobbelen en verwerken beslissingen
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "5000spel.h"

/* in deze file: */
void *xalloc(size_t);
char *doe_worp(char*, UFAST); 
FAST deel_van(char*, char*);
FAST waarde(char*, char*);
UFAST beurt(UFAST);
void main();

/* hoeveel geklep op het scherm */
int klepnivo;

  /* beveiligd geheugen aanvragen */
void *xalloc(size_t len)
{
  void *p;

  if (!(p=malloc(len)))
  {
    puts("te weinig geheugen!");
    exit(1);
  }
  return p;
}

/* gooi n keer een steen en sla op in buf */
char *doe_worp(char * buf, UFAST n) 
{
  UFAST i;
  int r;

  for (i=0; i<n ; i++)
  {
    do { r=rand(); } while (r>=(RAND_MAX/6)*6) ; 
    buf[i]='1'+(r%6);
  }
  buf[i]='\0';
  return buf;
}

/* komen alle karakters van *s1 minstens zo vaak voor in *s2 ? */
FAST deel_van(char *s1, char *s2)
{
  char *p,*q, *z;
  char buf[7];

  strcpy(buf,s2);
  q=buf+strlen(buf);
  for (p=s1 ; *p ; p++)
  {
    if ( (z=strchr(buf,*p)) ) 
      { 
	*z=*--q;
	*q='\0';
      }
    else return 0;
  }
  return 1;
}

/* hoeveel is *worp waard als *bak al uitligt */ 
FAST waarde(char *worp, char *bak)
{
  FAST i,t;
  char c,*p;
  char xxyyzz[7];
  
  if (strlen(worp)==0) return -1;
  c=worp[0]; t=0;
  for (p=worp ; *p ; p++) t+=((*p==c)?1:-7); 
  for (p=bak  ; *p ; p++) t+=((*p==c)?1:-7);
  if (t==6) return WINLIM; /* sextet */

  if ((t>3)&&(c!='1')&&(c!='5')) return 0;  /* moet door met sextet */
  c=bak[0];
  if ((c!='1')&&(c!='5'))
  {
    for (p=bak,t=0 ; *p ; p++) if (*p==c) t++;
    if (t>3) return -1; /* moest door met sextet */
  }
  
  if (strlen(worp)==6)
  {
    for (t=i=0, p=xxyyzz ; i<6 ; i++)
    { 
      if (strchr(worp,worp[i])==worp+i)
        if (t++<3) { *p++=worp[i]; *p++=worp[i]; }
    }
    if (t==6) return W_STRAAT;
    *p='\0';
    if ( (t==3) && deel_van(xxyyzz,worp) ) return W_3_PAAR;
  }

  for (i=0; i<6; ) xxyyzz[i++]=0;
  for (p=worp; *p; ) xxyyzz[*(p++)-'1']++;
  for (t=i=0; (i<6)&&(t>=0); i++)
  {
    if (xxyyzz[i]>=3)
      { t+= i?(i+1)*W_PIK:W_3_PIK; xxyyzz[i]-=3; }
    if (xxyyzz[i]) t= ((i%4)?-1:t+xxyyzz[i]* (i?W_VIJF:W_PIK));
  }
  return t;      
}

/* doe een beurt met begin score totsc */
UFAST beurt(UFAST totsc)
{
  UFAST brtsc,vb;
  FAST i;
  char c,doorg;
  char bak[7], worp[7], zet_uit[7];

  vb=brtsc=0;
  bak[0]='\0';
  do {
    c=bak[0];
    if (c) {
      for (i=1 ; (i<5) && (bak[i]==c) ; i++) ;
      c=(i==5) ? extra_gok(bak[0]) : '-';
    }
    else
	c='-';
    doe_worp(worp, 6-strlen(bak));
    if (klepnivo>=2) printf(" %s -%c- %s :",bak,c,worp);
    if (worp[0]==c) worp[0]=bak[0];

    teller=0;
    doorg=doorgaan(bak,worp,zet_uit,totsc,brtsc,vb);
    if (! deel_van(zet_uit,worp))
      zet_uit[0]='\0';

    i=waarde(zet_uit,bak);
    brtsc+=i;
    if (i<0) doorg=brtsc=0;
    if (i==0) doorg=1;
    strcat(bak,zet_uit);
    if (strlen(bak)==6)
    {
      bak[0]='\0';
      doorg=doorg || ( (++vb<BAKLIM) && (brtsc+totsc<WINLIM) );
    }
    if (klepnivo>=2) printf("(%lu) +%s : %d\n", teller, zet_uit, SC*brtsc);
  } while (doorg);
  return (brtsc<SCHRLIM) ? 0 : brtsc;
}

/* doe een aantal 5000-spelletjes */
void main()
{
  UFAST totsc,bt;
  uint  ap, pt, *ab;
  ulong somx,somx2;

  tact_init();

  printf("Hoevaak spelen ? ");
  scanf("%d", &ap);
  printf("Hoeveel uitvoer (0-3)");
  scanf("%d", &klepnivo);
  ab=xalloc(ap*sizeof(*ab));
  for (somx=somx2=pt=0 ; pt<ap ; pt++) 
  {
    for (totsc=bt=0 ; totsc<WINLIM ; )
    {
      totsc+=beurt(totsc); bt++;
      if (klepnivo) printf("%d:%d --> %d\n",pt,bt,SC*totsc);
    }
    ab[pt]=bt;
    somx+=bt; somx2+=bt*bt;
  }
  puts("Overzicht aantallen benodigde beurten:");
  for (pt=0 ; pt<ap ; pt++) printf("%d, ",ab[pt]);
  if (ap>1) printf("\ngemiddelde=%f; standaarddeviatie=%f\n",
		   ((float)somx)/ap,
		   sqrt((somx2-((float)somx*somx)/ap)/ap) );
}
