/* file: 5000spel.h 
 * door: Arnold Metselaar
 *
 * programma voor het 5000-spel (zie MCCM 83)
 * definities en prototypes
 */

#define FAST char
#define UFAST unsigned char
#define uint unsigned int
#define ulong unsigned long

/* constanten in het spelletje,
   scores worden gedeeld door 50: */
#define SC 50
#define BAKLIM 3
#define W_STRAAT 30
#define W_3_PAAR 20
#define W_3_PIK  20
#define W_PIK  2
#define W_VIJF  1
#define WINLIM  100
#define SCHRLIM 10
#define MINBAK (5*W_VIJF+W_PIK)
#define MAXBAK (W_3_PIK+6*W_PIK)

#define FAC 6000 /* factor voor verw_beurt() */

extern ulong teller;
extern int klepnivo;

/* algemene functies: */
extern void *xalloc(size_t);
extern char *doe_worp(char*, UFAST); 
extern FAST deel_van(char*, char*);
extern FAST waarde(char*, char*);

/* initialisatie voor het rekenwerk */
extern void tact_init(void);

/* beslissende functies */
extern FAST doorgaan(char*,char*,char*,UFAST,UFAST,UFAST);
extern char extra_gok(char);

/* waar het om gaat: rekenen ! */
extern uint verw_beurt(char*, UFAST, UFAST, UFAST);
extern uint macht(uint, uint);
extern int mapping(UFAST, UFAST, UFAST);

