/* file: 5000verw.c 
 * door: Arnold Metselaar
 * 
 * programma voor het 5000-spel (zie MCCM 83)
 * bereken verwachtingswaarden en andere zaken
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "5000spel.h"

#define C_NIKS 0
#define C_XXX  1
#define C_EG   2

/* in deze file : */
uint verw_beurt(char*, UFAST, UFAST, UFAST);
int mapping(UFAST,UFAST,UFAST);
uint macht(uint,uint);

  /* opslag voor mogelijke voortzettingen: */
struct tak
{
  char Worp[7];
  uint Kansen;
} ;

extern int ntak[6];
extern uint ntot[6];
extern struct tak *boom[6];

  /* opslag voor vooraf uitgerekende waarden  van  
     verw_beurt("",totsc,0,0)+FAC en
     verw_beurt("",totsc,brtsc,1 .. BAKLIM) */
extern uint RestB[WINLIM];
extern uint *tabel[BAKLIM];

  /* werkruimte voor verw_beurt:  */
extern uint *stapel;
extern int top; 

  /* statistiek: tel aanroepen van verw_beurt */
ulong teller;

/* bereken (FAC maal) de verwachtingswaarde van 
   het aantal beurten nodig na deze beurt, met keuze of men doorgooit.
   vereist: totsc<=WINLIM-SCHRLIM, totsc+brtsc< WINLIM */
uint verw_beurt(char *bak, UFAST totsc, UFAST brtsc, UFAST vb)
{ 
  char c,*p;
  int l,t,u,w;
  ulong som;
  struct tak *stam;
  uint *score, scx4, scx5, tbrt;
  char temp[7];
  int may_stop;
  uint zesmachtw;
  ulong max_som;
  

  teller++;
  if ((l=strlen(bak))==6)
    return tabel[(vb<BAKLIM)?vb:BAKLIM-1] [mapping(totsc,brtsc,vb+1)];

  som=0;
  c=bak[0];
  for (p=bak, t=0 ; *p ; p++) t+=((*p==c)?1:-7);
  if ((c!='1')&&(c!='5'))
  {
    switch(t) 
      {
        case 5: som=(long)144*RestB[totsc]; break;
        case 4: som=(long)190*RestB[totsc]; break;
        case 3: c=C_XXX; 
	        scx4=(long)190*RestB[totsc]/216;
		scx5=(long)144*RestB[totsc]/216;
		break;
      default : c=C_NIKS; break;
      }
    if (som) return som/216;
  }
  else
  {
    c=(t==5)? C_EG : C_NIKS;
  }
  may_stop = (brtsc>=SCHRLIM)  && (l || (vb>=BAKLIM));
  zesmachtw = ntot[l];
  if (may_stop)
  {
      max_som = RestB[totsc+brtsc] * zesmachtw;
      if (C_EG == c) max_som += RestB[totsc];
  }

  score=&(stapel[top]); top+=ntak[l];
  stam=boom[l];

  for (u=0 ; u<ntak[l] ; u++)
  {
    if ( (t=waarde(stam[u].Worp,bak)) >=0 )
    {
      tbrt=(uint) t+brtsc; 
      score[u]=(tbrt+totsc < WINLIM)
	       ? verw_beurt( strcat(strcpy(temp,bak),stam[u].Worp), 
			     totsc, tbrt, vb)
               : 0 ;
    }
    else score[u]=RestB[totsc];
    for (w=0; w<u ; w++)
      if ( (score[w]<score[u]) && deel_van(stam[w].Worp,stam[u].Worp) )
	score[u]=score[w];

    som+=(ulong) score[u]*stam[u].Kansen ;

    /* overweeg evt. doorgokken als bak = xxx: */
    if ((c==C_XXX) && ( (w=strlen(stam[u].Worp)) < 3))
    {  
      static UFAST kx4[3]={27, 6, 1 };
      static UFAST kx5[3]={ 9, 1, 0 };
      static UFAST nxn[3]={60,16, 4 };

      if (scx5<score[u]) 
	som-=(ulong)(score[u]-scx5)*(stam[u].Kansen*kx5[w]/nxn[w]);
      if (scx4<score[u]) 
	som-=(ulong)(score[u]-scx4)*(stam[u].Kansen*kx4[w]/nxn[w]);
    }
    if (may_stop && (som >= max_som)) 
      break; 
  }

  if (may_stop && (som >= max_som))
      u=RestB[totsc+brtsc];
  else
  {
      if (c==C_EG) som-=score[0]-0; /* correctie bij extra gok */ 
      u=som/zesmachtw;
  }
  top-=ntak[l];
  return u;
}

/* geef de plaats van verw_beurt ("",t,b,v) in tabel[v], 
   nodig om het gegeugen efficint te gebruiken. */ 
int mapping(UFAST t, UFAST b, UFAST v)
{
  int l,k;

  if (v>=BAKLIM) 
  {
    l=WINLIM-BAKLIM*MINBAK+1;
    k=t;
    v=BAKLIM;
  }
  else
  {
    l=v*(MAXBAK-MINBAK)+1;
    k=(t>(WINLIM-v*MAXBAK))?t-(WINLIM-v*MAXBAK):0;
  }
  return l*t -k*(k+1)/2 + b-v*MINBAK;
}
  
  /* x tot de macht y */
uint macht(uint x,uint y)
{
  int res;

  for (res=1; y ; y--) res*=x; /* goed genoeg voor kleine y */
  return res; 
}

