	.org	C000H	; Direccin de inicio
	.bios           ; Define los nombres de las rutinas de la bios
        .BASIC          ; Salida cargable desde basic
        .db      "FIFEPONG by Tin Whistle Soft"
        .start  INICIO  ; Direccin de inicio
	

;---------------------------------------------------------
; CONSTANTES
;---------------------------------------------------------
; Posiciones de la VRAM
        CHRTBL  equ     0000h   ; Tabla de patrones
        NAMTBL  equ     1800h   ; Tabla de nombres
        CLRTBL  equ     2000h   ; Tabla de colores
        SPRTBL  equ     3800h   ; Patrones de sprites
        SPRATR  equ     1b00h   ; Atributos de sprites
; Variables de sistema
        CLIKSW  equ     0f3dbh  ; Sonido de teclado
        FORCLR  equ     0f3e9h  ; Color de tinta
	STATFL	EQU	0F3E7H	; VDP STATUS REGISTER

	MAX_X	equ	222	; Posicin de rebote derecho
	MIN_X	equ	24	; Posicin de rebote izquierdo
	MAX_Y	equ	168	; Posicin de rebote inferior
	MIN_Y	equ	16	; Posicin de rebote superior

	CENTRO_Y	EQU	71	; Centro vertical
	CENTRO_X	EQU	100
	VEL_INICIAL_X	EQU	5	; Velocidad inicial de la bola
	VEL_PALA_Y	EQU	3	; Velocidad de las palas
	MAX_GOLES	EQU	$10	; Mximo de goles EN BCD

;---------------------------------------------------------
; Inicio del programa
;---------------------------------------------------------
INICIO:
	CALL	INICIALIZACION
	CALL	INIT_SPRITES
	CALL	SPLASH
NUEVA_PARTIDA:
	CALL	OCULTA_SPRITES
	CALL	CLS
	CALL	MENU
	CALL	CLS

	CALL	PINTA_PANTALLA
	CALL	PINTA_SPRITES
	CALL	PINTA_MARCADOR
	
;---------------------------------------------------------
; Bucle principal
;---------------------------------------------------------
BUCLE:
	CALL	MOVER_BOLA
	CALL	CHECK_GOL
	CALL	CHECK_GANADOR
	
	JR	Z,NUEVA_PARTIDA

	CALL	LEER_JOYSTICK
	CALL	PINTA_SPRITES
	
	halt
	halt

	CALL	CHECK_REBOTE_HORIZONTAL
	CALL	CHECK_REBOTE_VERTICAL
	JR	BUCLE
	RET

OCULTA_SPRITES:
	ld      hl,SPRATR
        ld      a,208
        call    WRTVRM
	RET
;---------------------------------------------------------
; Guarda en AUX_BUFFER los cdigos ascii correspondientes 
; al nmero BCD almacenado en A
;
; A = NMERO EN BCD
; DE = POSICION DENTRO DE LA VRAM DONDE ESCRIBIR
; MODIFICA: IY, DE ,BC
;---------------------------------------------------------
WRITE_BCD_8:
	LD	HL,AUX_BUFFER
	LD	C,A

	SRL	A
	SRL	A
	SRL	A
	SRL	A
	ADD	48
	LD	[HL],A
	
	LD	A,C
	AND	00001111B

	ADD	48
	INC	HL
	LD	[HL],A
	
	LD	HL,NAMTBL
	ADD	HL,DE

	PUSH	HL
	POP	DE
	
	LD	HL,AUX_BUFFER
	
	LD	BC,2
	CALL	LDIRVM

	RET

;---------------------------------------------------------
; Chequea si ha habido goles, y actualiza las posiciones
; GOLES_1 y GOLES_2. Si ha habido gol, posiciona la bola en
; en centro de la pantalla avanzado hacia el campo del
; goleador
;---------------------------------------------------------
CHECK_GOL:
	LD	A,[GOL_1]
	LD	B,A
	LD	A,[BOLA_X]
	; Compara BOLA_X con GOL_1
	CALL	RESTA_SIN_SIGNO
	JP	M,@@GOL2	; Si BOLA_X<GOL_1, vamos a GOL2
	
	LD	C,A
	LD	A,[GOL_2]
	LD	B,A
	LD	A,C
	; Compara BOLA_X con GOL_2
	CALL	RESTA_SIN_SIGNO
	JP	P,@@GOL1	; Si BOLA_X > GOL_1 vamos a GOL1
	RET

@@GOL1:
	LD	HL,GOLES_1
	
	LD	A,-VEL_INICIAL_X	; La bola avanzar hacia la izquierda
	LD	[BOLA_VELX],A		

	LD	A,2
	LD	[TURNO],A		; El turno ser para el jugador 2


	JP	@@GOL_COMUN

@@GOL2:
	LD	HL,GOLES_2

	LD	A,VEL_INICIAL_X		; La bola avanzar hacia la derecha
	LD	[BOLA_VELX],A
	
	LD	A,1			; El turno ser para el jugador 1
	LD	[TURNO],A


@@GOL_COMUN:


	LD	A,[HL]			; Incrementamos el nmero de goles
	ADD	A,1			; del jugador que ha marcado
	DAA				; Como los guardamos en BCD, ajustamos
	LD	[HL],A			; Y guardamos en su posicin

	CALL	PINTA_GOL		; Pinta el texto GOOL

	LD	A,CENTRO_X		; Posicionamos la bola en el centro
	LD	[BOLA_X],A
	LD	A,CENTRO_Y
	LD	[BOLA_Y],A
	XOR	A			; Ponemos la velocidad vertical de la
	LD	[BOLA_VELY],A		; bola a 0

	CALL	PINTA_MARCADOR		; Pintamos el marcador
	
	RET

;---------------------------------------------------------
; Comprueba si algn jugador ha llegado a 10 goles
;---------------------------------------------------------
CHECK_GANADOR:
	LD	A,[TURNO]
	CP	1
	JP	Z,@@GANA2
@@GANA1:			; Si estamos en el turno 1
	LD	A,[GOLES_1]
	CP	MAX_GOLES
	RET	NZ

	LD	A,49
	JP	@@GANA_FIN
@@GANA2:			; Si estamos en el turno 2
	LD	A,[GOLES_2]
	CP	MAX_GOLES
	RET	NZ
	LD	A,50
@@GANA_FIN:
	LD	[TEXTO_GANADOR_FIN],A	; Informamos de quin gana...
	LD	HL,TEXTO_GANADOR
	LD	DE,NAMTBL+10
	LD	BC,14
	CALL	LDIRVM

	LD	B,FFH			; Esperamos un ratito...
	CALL	RETARDO2

	XOR	A			; Reseteamos los goles
	LD	[GOLES_1],A
	LD	[GOLES_2],A

	SUB	A			; Ponemos a 1 el flag Z
	RET

;---------------------------------------------------------
; Pinta el texto GOOL, espera un ratito y borra el marcador
;---------------------------------------------------------
PINTA_GOL:				
	LD	BC,7
	LD	HL,TEXTO_GOL
	LD	DE,NAMTBL+13
	CALL	LDIRVM

	LD	B,100
	CALL	RETARDO2

	RET

;---------------------------------------------------------
; Pinta el marcador con los goles de cada jugador
;---------------------------------------------------------

PINTA_MARCADOR:
	LD	A,32
	LD	BC,32
	LD	HL,NAMTBL
	CALL	FILVRM

	LD	A,[GOLES_1]
	LD	DE,13
	CALL	WRITE_BCD_8

	LD	A,[GOLES_2]
	LD	DE,18
	CALL	WRITE_BCD_8

	RET

;---------------------------------------------------------
; Lee los joysticks y mueve las palas
;---------------------------------------------------------
LEER_JOYSTICK:
	XOR	A		; Lee el teclado
	CALL	GTSTCK
	JR	Z,@@LEE1
	CALL	@@MUEVE_PALA1
	JR	@@LEE2	
@@LEE1:				; Lee el joystick 1
	LD	A,1
	CALL	GTSTCK
	JR	Z,@@LEE2
	CALL	@@MUEVE_PALA1

@@LEE2:				
	LD	A,[NUM_PLAYERS]	; Si slo hay un jugador, 
	CP	1		; hacemos que mueva la cpu
	JP	Z,CPU_MOVE

	LD	A,2		; Si hay dos jugdores, leemos
	CALL	GTSTCK		; el joystick 2
	RET	Z
	CALL	@@MUEVE_PALA2
@@FIN:
	RET

@@MUEVE_PALA1:
	CP	1		; Dependiendo del valor de A,
	JP	Z,PALA1_ARRIBA	; movemos la pala 1 arriba
	CP	5
	JP	Z,PALA1_ABAJO	; o abajo
	RET

@@MUEVE_PALA2:			; Dependiendo del valor de A,
	CP	1		; movemos la pala 2 arriba   
	JP	Z,PALA2_ARRIBA	                             
	CP	5		
	JP	Z,PALA2_ABAJO	; o abajo                    
	RET

;------------------------
; Comprueba si una pala se puede mover hacia arriba.
; Si P, no puedo mover
; Si M, puedo mover
; En A llega la posicin de la pala a chequear
; Modifica B
;------------------------
PUEDO_MOVER_ARRIBA:
	LD	B,A
	LD	A,MIN_Y
	CALL	RESTA_SIN_SIGNO
	RET

;------------------------
; Comprueba si una pala se puede mover hacia abajo
; Si M, no puedo mover
; Si P, puedo mover
; En A llega la posicin de la pala a chequear
; Modifica B,C
;------------------------
PUEDO_MOVER_ABAJO:
	LD	B,24
	CALL	SUMA_SIN_SIGNO

	LD	B,A

	LD	A,MAX_Y
	CALL	RESTA_SIN_SIGNO
	RET

;----------------------------------------------------------
; Intentamos mover la pala 1 hacia arriba
;----------------------------------------------------------
PALA1_ARRIBA:
	LD	HL,PALA1_Y
	JP	PALAX_ARRIBA

;----------------------------------------------------------
; Intentamos mover la pala 2 hacia arriba
;----------------------------------------------------------
PALA2_ARRIBA:
	LD	HL,PALA2_Y
	JP	PALAX_ARRIBA


;----------------------------------------------------------
; Mueve una pala hacia arriba
; En HL llega la direccin de la posicin y de la pala
;----------------------------------------------------------
PALAX_ARRIBA:
	;PRIMERO COMPROBAMOS SI PODEMOS MOVER HACIA ARRIBA...
	LD	A,[HL]
	CALL	PUEDO_MOVER_ARRIBA
	RET	P	;SI ES POSITIVO, NO PODEMOS MOVERLO...

	LD	A,VEL_PALA_Y
	LD	B,A
	LD	A,[HL]
	SUB	B
	LD	[HL],A
	RET

;----------------------------------------------------------
; Mueve una pala hacia abajo
; En HL llega la direccin de la posicin y de la pala
;----------------------------------------------------------
PALAX_ABAJO:
	LD	A,[HL]
	CALL	PUEDO_MOVER_ABAJO
	RET	M

	LD	A,[HL]
	LD	B,A
	LD	A,VEL_PALA_Y
	ADD	B
	LD	[HL],A
	RET

;----------------------------------------------------------
; Mueve la pala 1 hacia abajo
;----------------------------------------------------------
PALA1_ABAJO:
	LD	HL,PALA1_Y
	JP	PALAX_ABAJO

;----------------------------------------------------------
; Mueve la pala 2 hacia abajo
;----------------------------------------------------------
PALA2_ABAJO:
	LD	HL,PALA2_Y
	JP	PALAX_ABAJO

;----------------------------------------------------------
; Mueve la pala de la CPU
;----------------------------------------------------------
CPU_MOVE:
	LD	A,[TURNO]
	CP	1
	JR	Z,@@TURNO_1

@@TURNO_2:
	LD	A,CENTRO_Y
	JR	@@COMUN
	
@@TURNO_1:
	LD	A,[BOLA_Y]
@@COMUN:
	LD	B,A

	LD	A,[PALA2_Y]
	CALL	RESTA_SIN_SIGNO

	;SI ES POSITIVO MOVEMOS HACIA ABAJO
	RET	Z
	JP	P,PALA2_ARRIBA
	JP	PALA2_ABAJO

;----------------------------------------------------------
; Rebota contra una de las palas si fuera necesario...
;----------------------------------------------------------
CHECK_REBOTE_HORIZONTAL:
	LD	A,[STATFL]	; Si el bit 5 de STATFL es 1,
	AND	00100000b	; es que ha habido choque de
	CP	00100000b	; sprites, con lo que rebotaremos...
	RET	NZ

;----------------------------------------------------------
; Rebota contra una de las palas
;----------------------------------------------------------
REBOTA_HORIZONTAL:

	LD	A,[TURNO]
	CP	1
	JR	NZ,@@TURNO2

@@TURNO1:
	LD	A,[PALA2_Y]
	JR	@@CALCULA_PUNTO_CHOQUE

@@TURNO2:
	LD	A,[PALA1_Y]

;-----
; En A llega la posicin de la pala en la que rebotar
;-----
@@CALCULA_PUNTO_CHOQUE:
	LD	B,16		; Ponemos en A la posicin de la bola + 16
	CALL	SUMA_SIN_SIGNO

	LD	B,A
	LD	A,[BOLA_Y]
	CALL	RESTA_SIN_SIGNO		;B=POS BOLA-POS PALA
	
	; Ahora tenemos en A la diferencia entre la bola y el centro de la pala

@@AJUSTA_PUNTO_CHOQUE:
	; SI A>16 A=16 ... SI A<-16 A=-16
	CP	16
	JP	M,@@BOLA_POR_ENCIMA
	LD	A,15
	JR	@@AJUSTA_VELOCIDAD
@@BOLA_POR_ENCIMA:
	CP	-15
	JP	P,@@AJUSTA_VELOCIDAD
	LD	A,-15

@@AJUSTA_VELOCIDAD:
	;A VALE ENTRE -16 Y 16
	ADD	15
	;A VALE ENTRE 0 Y 32
	
	LD	HL,VELOCIDADES_Y
	LD	C,A
	LD	B,0
	ADD	HL,BC
	LD	A,[HL]

	CP	0
	JR	NZ,@@PON_VELOCIDAD
	LD	A,[BOLA_VELY]

@@PON_VELOCIDAD:
	LD	[BOLA_VELY],A

;AQU POSICIONAMOS LA BOLA...
	LD	A,[TURNO]
	CP	1
	JR	Z,@@BOLA_EN_MAX

	LD	A,MIN_X
	LD	[BOLA_X],A
	JR	@@INCREMENTA_TURNO
@@BOLA_EN_MAX:
	LD	A,MAX_X
	LD	[BOLA_X],A

@@INCREMENTA_TURNO:
	LD	A,[TURNO]
	INC	A

	CP	3
	JP	NZ,@@INCREMENTA_TURNO_FIN
	LD	A,1
@@INCREMENTA_TURNO_FIN:
	LD	[TURNO],A

	LD	A,[BOLA_VELX]
	NEG
	LD	[BOLA_VELX],A

	RET


CHECK_REBOTE_VERTICAL:
	LD	A,[BOLA_Y]
	LD	B,A
	LD	A,MIN_Y
	;SUB	B
	CALL	RESTA_SIN_SIGNO
	JP	P,@@ARRIBA

	LD	A,MAX_Y
	;SUB	B
	CALL	RESTA_SIN_SIGNO
	RET	P
	JR	@@ABAJO
@@ARRIBA:
	LD	A,MIN_Y
	ADD	8
	LD	C,A
	JR	@@FIN
@@ABAJO:
	LD	A,MAX_Y
	;ADD	8
	LD	B,8
	CALL	RESTA_SIN_SIGNO
	LD	C,A
@@FIN:
	LD	A,[BOLA_VELY]
	NEG
	LD	[BOLA_VELY],A
	
	LD	A,C
	LD	[BOLA_Y],A
	
	RET


PREPARA_SIN_SIGNO:
	LD	E,B
	LD	D,0
	LD	L,A
	LD	H,0
	CP	A	;RESETAMOS LOS FLAGS

	RET

;------------------------------
; Resta A-B tratando a y b como enteros sin signo
;------------------------------
RESTA_SIN_SIGNO:
	PUSH	DE
	PUSH	HL
	CALL	PREPARA_SIN_SIGNO
	SBC	HL,DE
	JR	FIN_SIN_SIGNO

;------------------------------
; Suma A+B sin signo tratando a y b como enteros sin signo
;------------------------------
SUMA_SIN_SIGNO:
	PUSH	DE
	PUSH	HL
	CALL	PREPARA_SIN_SIGNO
	ADD	HL,DE
;	JP	FIN_SIN_SIGNO

FIN_SIN_SIGNO:
	LD	A,L
	POP	HL
	POP	DE
	RET	

;------------------
;Mueve la bola segn las velocidades BOLA_VELX y BOLA_VELY
;------------------
MOVER_BOLA:
	LD	A,[BOLA_X]
	LD	B,A
	LD	A,[BOLA_VELX]
	ADD	B
	LD	[BOLA_X],A

	LD	A,[BOLA_Y]
	LD	B,A
	LD	A,[BOLA_VELY]
	ADD	B
	LD	[BOLA_Y],A
	RET

;----------------------
;Pinta la pantalla de presentacin
;----------------------
SPLASH:

        CALL	OCULTA_SPRITES

	LD	HL,TEXTO_FIFEPONG
	LD	DE,NAMTBL+10*29+10
	LD	BC,8
	CALL	LDIRVM

	LD	B,FFH
	CALL	RETARDO2
	
	RET


;-----------------------------
; Inicializa los sprites
;-----------------------------
INIT_SPRITES:
;PELOTA
	LD	HL,SPRITE_BOLA
	LD	bc,4
	ld	de,SPRTBL
	CALL	LDIRVM
;PALAS
	LD	DE,SPRTBL+32
	LD	HL,SPRITE_PALA
	LD	BC,16
	CALL	LDIRVM

	LD	DE,SPRTBL+64
	LD	HL,SPRITE_PALA
	LD	BC,16
	CALL	LDIRVM

	RET


;-----------------------
;Pasa los atributos de los sprites de la ram a la vram
;-----------------------
PINTA_SPRITES:
	LD	HL,ATRIBUTOS_SPRITES
	LD	DE,SPRATR
	LD	BC,12
	CALL	LDIRVM

	RET


;------------------------
;Inicializaciones varias...
;------------------------
INICIALIZACION:
; BASIC: SCREEN ,,0
        xor     a
        ld      [CLIKSW],a
; Inicializa el PSG
        call    GICINI
; Establece los colores adecuados
; BASIC: COLOR 15,0,0
        ld      hl,FORCLR
        ld      [hl],15
        inc     hl
        ld      [hl],0
        inc     hl
        ld      [hl],0
; Elimina el resumen de teclas de funcion
; BASIC: KEY OFF
	call    ERAFNK
; Establece el modo de texto de 32 columnas
; BASIC: SCREEN 1
        call    INIT32
; Permite sprites de 16x16
; BASIC: SCREEN ,2
        ld      bc,0e301h
        call    WRTVDP

;REDEFINIMOS EL CARCTER 0
	LD	HL,CHRTBL
	LD	A,$FF
	LD	BC,8
	CALL	FILVRM
	RET


;--------------------------
;Pregunta si se quiere jugar con 1 o 2 jugadores
;--------------------------
MENU:
	LD	HL,TEXTO_MENU
	LD	DE,NAMTBL+(10*29)+7
	LD	BC,15
	CALL	LDIRVM	
	CALL	KILBUF

@@BUCLE:
	CALL	CHGET
	JR	Z,@@BUCLE
	SUB	48
	LD	[NUM_PLAYERS],A

	LD	A,32
	LD	HL,NAMTBL+10*29+10
	LD	BC,16
	CALL	FILVRM
	RET


;-------------------
; HACE UNA PAUSA
; B: NUMERO DE ITERACIONES
;-------------------
RETARDO2:
@@BUCLE:
	halt
	DJNZ @@BUCLE 
	ret

;------------------------------
; Pinta el terreno de juego
;------------------------------
PINTA_PANTALLA:

	LD	HL,NAMTBL+32
	LD	BC,32
	XOR	A
	CALL	FILVRM

	LD	HL,NAMTBL+(22*32)
	LD	BC,32
	XOR	A
	CALL	FILVRM
		
	RET


;-------------------------
; DEFINICION DE VARIABLES
;-------------------------
TURNO:
.db	1		;Define qu jugador acaba de tocar la bola
BOLA_VELX:
.db	VEL_INICIAL_X	;Velocidad X de la bola
BOLA_VELY:
.db	0		;Velocidad Y de la bola

GOL_1:
.db	MIN_X-16	;Posicin X a partir de la cual el jugador 1 recibe un gol
GOL_2:
.db	MAX_X+16	;Posicin Y a partir de la cual el jugador 2 recibe un gol

GOLES_1:
.db	0		;Goles del jugador 1 en BCD
GOLES_2:	
.db	0		;Goles del jugador 2 en BCD

TEXTO_GANA_FIFETON:
.db	"GANA JUGADOR"
TEXTO_FIFEPONG:
.db	"FIFEPONG"


ATRIBUTOS_SPRITES:
BOLA_Y:			;Sprite bola
.db	120
BOLA_X:
.db	60
.db	0,15
PALA1_Y:		;Sprite pala 1
.db	50
PALA1_X:
.db	MIN_X-8
.db	4,15

PALA2_Y:		;Sprite pala 2
.db	50
PALA2_X:
.db	MAX_X+8
.db	8,15


;---------
; SPRITES
;---------

SPRITE_BOLA:
.db 01100000b
.db 11110000b
.db 11110000b
.db 01100000b

SPRITE_PALA:
.db 01100000b
.db 11110000b
.db 11110000b
.db 11110000b
.db 11110000b
.db 11110000b
.db 11110000b
.db 11110000b
.db 11110000b
.db 11110000b
.db 11110000b
.db 11110000b
.db 11110000b
.db 11110000b
.db 11110000b
.db 01100000b


;Tabla de velocidades de y
VELOCIDADES_Y:

.db -4,-4,-3,-3,-3,-2,-2,-2,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,2,2,2,3,3,3,4,4

AUX_BUFFER:
.db 0,0


NUM_PLAYERS:
.db 1			;Nmero de jugadores

TEXTO_GOL:
.db	"GOOOOOL"

TEXTO_MENU:
.DB	"1 O 2 JUGADORES"

TEXTO_GANADOR:
.db "GANA JUGADOR "
TEXTO_GANADOR_FIN:
.db	0
