;---------------------------------------------------------
; PONG512 v1.34f
;---------------------------------------------------------
;
; Version history
;
; March 2007 ("whooops!! a bug!!" time...)
; v1.34f - Fixed a bug: ball can rebound on walls and mark goal in the same frame
;        - 1007 bytes (Code size 1000 bytes + 7 bytes header)
;
; February 2006 ("Bored in Greece" time...)
; 
; v1.34 - Keyboard Click off (for use outside Namake's Bridgedrome)
;       - Perfect version number! '^_^'
;       - Some routines rewritted -> small size!
;       - 1007 bytes (Code size 1000 bytes +7 bytes header)
;
; December 2005 ("A mini-game inside a game" time...)
;
; v1.33 - Version included in Namake's Bridgedrome game
;       - Some minor add-ons to work properly inside NB
;       - 1018 bytes (Code size 1011 bytes +7 bytes header)
; v1.32 - Player 1 can use either cursors or joy 1
;       - Sound initialization corrected (bit 7 reg 7 on)
;       - 1011 bytes (Code size 1004 bytes +7 bytes header)
; v1.31 - Smallest size 1000 bytes! (Code size 993 bytes +7 bytes header)
;       - CHKTRG routine rewritted
;       - OR A clears carry flag, same as SCF and CCF
;
; September 2005 ("I can do it better" time...)
;
; v1.3  - Synchronization using HALT instead of interrupt
;       - ESC key returns to BASIC (Screen 0)
;       - VRAM addresses readed from RAM
;       - Sound 7,62 (prevent strange sounds: only tone in channel A)
;       - SCF and CCF to prevent SBC calculation errors
;       - All coordinates revised and fixed
;       - Smoother ball speed increment (half pixel/frame)
;       - Routines relocated and rewritted (smaller!)
; v1.27 - Changes forbidden when ball is crossing a wall
;       - Some routines relocated to decrement size '^_^'
;       - Some routines rewritted to decrement size '^_^'
;
; August 2005 ("Let's make a 1Kb pong during the vacations" time...)
;
; v1.26 - Better stick control, black background
; v1.25 - First public release, transparent background
; Lower versions: not fully playable and lost in ciberspace...
;---------------------------------------------------------
; A 1007 bytes MSX PONG Clone for the LET'S PONG contest
;       !!! NO AUTOMATIC PACKING ROUTINES USED !!!
;---------------------------------------------------------
; Assembled with asMSX v0.11
;---------------------------------------------------------
;     SapphiRe (code, graphics & manual packing '^_^')
;     KNM (sound and testing)
;     MANDIC & SAURET (testing)
;     SALLY (moral support)
; THANKS TO:
;     WYZ (some routines ideas)
;     MadriSX (real MSX and joystick control testing)
;     Viejo Archivero (HALT synchronization idea)
;     JLTurSan (OR A instead of SCF+CCF and bit 7 of PSG#7)
;---------------------------------------------------------
; INSTRUCTIONS
;---------------------------------------------------------
; Player one (left side) controls the bat with cursors
; or joystick connected to port 1. Player two (right side)
; controls the bat with joystick connected to port 2.
;
; Triggers changes randomly the pong board.
;
; Press ESC Key during game to return to BASIC
;---------------------------------------------------------

		.bios					; Define MSX BIOS routines
		.basic					; BASIC Bloadable file
		.org	$C000				; Origin

		; --- MEMORY VARIABLES ---
		RAMBUFFER	EQU	$C400		; Screen Ram Buffer (lower byte must be 0)
		BALLX		EQU	$C7E0		; BallX pos (8.8 fix point real)
		BALLY		EQU	$C7E2		; BallY pos (8.8 fix point real)
		SPRATT2		EQU	$C7E4		; Sprite Attributes Work zone
		SPEEDLEVEL	EQU	$C7F0		; Speed Level
		WALLCHANGE	EQU	$C7F1		; Wall Change Counter
		ADDX		EQU	$C7F2		; Horizontal Speed (8.8 fix point real)
		ADDY		EQU	$C7F4		; Vertical Speed (8.8 fix point real)
		SCP1		EQU	$C7F6		; Score Player 1
		SCP2		EQU	$C7F7		; Score Player 2
		; --- MEMORY VARIABLES ---

		; --- CONSTANT VALUES ---
		BATX1		EQU	24		; BAT 1 X position
		BATX2		EQU	228		; BAT 2 X position
		WALLTIME	EQU	110		; Minimum vblanks between two wall changes
		; --- CONSTANT VALUES ---

INIT:		; --- COLOR 15,1,1 : SCREEN 1,3 ---
		ld	a,15				; COLOR 15
		ld	[$F3E9],a
		ld	hl,$0101			; COLOR ,1,1
		ld	[$F3EA],hl
		call	INIT32				; SCREEN 1
	        ld      bc,$e301
	        call    WRTVDP				; SCREEN 1,3
		; --- COLOR 15,1,1 : SCREEN 1,3 ---
 
		; --- COPY GRAPHICS TO VRAM ---
		ld	hl,GRAPHICSC			; GRAPHICS data (Characters)
		ld	de,[$F3C1]			; Pattern Generator Table Screen 1
		ld	bc,32				; 32 bytes (4 characters)
		call	LDIRVM				; Transfer to VRAM
		; --- COPY GRAPHICS TO VRAM ---

		; --- SOUND INIZIALIZATION ---
		ld	a,7				; a = 7
		ld	e,128+62			; e = 62 + 128
		call	WRTPSG				; Sound 7,190 (noise disabled)
		inc	a				; a = 8
		ld	e,16				; e = 16
		call	WRTPSG				; Sound 8,16 (enveloppes control volume)
		; --- SOUND INIZIALIZATION ---

		jp	BOARD				; Draw BOARD and initialize variables

WALLREBOUND:	; --- CHECKS WALLS REBOUND ---
		exx					; Alternative registers
		ld	bc,0				; b' = 0  c' = 0
		exx					; Normal registers
		ld	de,[SPRATT2]			; e = INT(BALLY) , d = INT(BALLX)
		inc	e				; Adjust sprite coordinates to graphics coordinates
@@UL:		inc	d				; Increment X point
		inc	e				; Increment Y point
		call	GETCHAR				; Get character in this point
		or	a				; if ( a == 0 ) then...
		jr	z,@@UR				; ...goto @@UR
		exx					; Alternative registers
		inc	b				; Increment b'
		inc	c				; Increment c'
		exx					; Normal registers
@@UR:		ld	a,5				; 5 points right
		add	a,d				; a = New X point
		ld	d,a				; e = New X point
		call	GETCHAR				; Get character in this point
		or	a				; if ( a == 0 ) then...
		jr	z,@@LR				; ...goto @@LR
		exx					; Alternative registers
		dec	b				; Decrement b'
		inc	c				; Increment c'
		exx					; Normal registers
@@LR:		ld	a,5				; 5 points down
		add	a,e				; a = New Y point
		ld	e,a				; e = New Y point
		call	GETCHAR				; Get character in this point
		or	a				; if ( a == 0 ) then...
		jr	z,@@LL				; ...goto @@LL
		exx					; Alternative registers
		dec	b				; Decrement b'
		dec	c				; Decrement c'
		exx					; Normal registers
@@LL:		ld	a,251				; 5 points left
		add	a,d				; a = New X point
		ld	d,a				; d = New X point
		call	GETCHAR				; Get character in this point
		or	a				; if ( a == 0 ) then...
		exx					; Alternative registers
		jr	z,@@CHANGE			; ...goto @@CHANGE
		inc	b				; Increment b'
		dec	c				; Decrement c'
@@CHANGE:	ld	a,b				; a = b
		or	c				; if ( (b OR c) == 0 ) then...
		ret	z				; ...return (no wall rebound)
		ld	a,b				; a = sign of new ADDX (0 if no change)
		ld	hl,[ADDX]			; hl = ADDX
		call	NEWADD				; hl = New ADDX on rebound
		ld	[ADDX],hl			; New ADDX stored
		ld	a,c				; a = sign of new ADDY (0 if no change)
		ld	hl,[ADDY]			; hl = ADDY
		call	NEWADD				; hl = New ADDY on rebound
		ld	[ADDY],hl			; New ADDY stored		
		; --- CHECKS WALLS REBOUND ---

SOUND2:		; --- Sound Effects ---
		ld	e,94				; e = 94
		jr	SOUND_12			; goto SOUND_12 (common sounds for SOUND1 and SOUND2)
SOUND1:		ld	e,34				; e = 34
SOUND_12:	ld	d,13				; d = 13
		ld	c,2				; c = 2
		jr	PLAY				; goto PLAY (common routine for all SOUNDS)
SOUND3:		ld	e,234				; e = 234
		ld	d,8				; d = 8
		ld	c,4				; c = 4
PLAY:		xor	a				; a = 0
		call	WRTPSG				; Sound 0,e
		ld	a,11				; a = 11
		ld	e,168				; e = 168
		call	WRTPSG				; Sound 11,168
		inc	a				; a = 12
		ld	e,d				; e = d
		call	WRTPSG				; Sound 12,d
		inc	a				; a = 13
		ld	e,c				; e = c
		jp	WRTPSG				; Sound 13,c and return
		; --- Sound Effects ---

CHECKGOAL:	; --- CHECK GOAL ROUTINE ---
		ld	hl,SCP1				; hl -> Score Player 1
		ld	b,49				; b = 1 (Player who mark goal)
		ld	a,[BALLX+1]			; a = BALLX
		cp	245				; if ( a >= 245 ) then...
		jr	nc,@@GOAL			; ...goto @@GOAL (goal of player 1)
		cp	4				; if ( a >= 4 ) then...
		ret	nc				; ...return (no goals)
		inc	hl				; hl -> Score Player 2
		inc	b				; b = 2 (Player who mark goal)
@@GOAL:		call	SOUND3				; Goal Sound Effect
		ld	a,57				; a = ord('9')
		cp	[hl]				; if ( a = Score of player who mark goal) then...
		jr	z,GAMEOVER			; ...goto GAMEOVER
		inc	[hl]				; Increment score
		jp	INITSPRITES			; Show scores, initialize sprites and return
		; --- CHECK GOAL ROUTINE ---

GAMEOVER:	; --- 1P/2P WINS text ---
		pop	de				; POP Return from CHECKGOAL
		ld	a,b				; a = ASCII Number 1/2
		ld	[TEXT1],a			; Set winner player
@@LOOP:		call	CLEARRAM			; Clears RAM buffer
		ld	IY,TEXT1			; xP
		ld	hl,RAMBUFFER+$008A		; Destination
		call	PUTBIGTEXT			; BIG TEXT IN RAM
		inc	IY				; WINS
		ld	hl,RAMBUFFER+$0184		; Destination
		call	PUTBIGTEXT			; BIG TEXT IN RAM
		call	RAM2VRAM			; Copy RAM to VRAM
		call	WAITTRIG			; Wait Triggers
		; --- 1P/2P WINS text ---

BOARD:		; --- INITIALISES GAME ---
		; --- DRAW BASIC BOARD ---
		call	CLEARRAM			; Clear RAM buffer
		ld	hl,RAMBUFFER+$0001		; Origin
		ld	a,3				; Fill with 3
		ld	bc,765				; Length
		call	FILLRAM				; Fill RAM
		ld	hl,RAMBUFFER+$001F		; Origin
		xor	a				; Fill with 0
		ld	[$F3DB],a			; SCREEN 1,3,0 (we take benefit that here a is 0)
		ld	bc,705				; Length
		call	FILLRAM				; Fill RAM
		ld	hl,$0201			; Central line (characters 1 and 2)
		ld	[RAMBUFFER+$002F],hl		; Show characters in RAM
		ld	hl,RAMBUFFER+$0020		; Origin
		ld	de,RAMBUFFER+$0040		; Destination = Origin+32
		ld	bc,672				; Length
		ldir					; Copy central line
		ld	hl,$3030			; h = l = Ord('0')
		ld	[SCP1],hl			; Initial scores
		; --- DRAW BASIC BOARD ---

		; --- COPY SPRITE DEFINITION TO VRAM ---
		ld	hl,GRAPHICSS			; GRAPHICS data (Sprites)
		ld	de,[$F3C5]			; de = Sprite Generator Table Screen 1
		push	de				; Store de (Sprite Generator Table Screen 1)
		ld	bc,4				; bc = 4 
		call	LDIRVM				; Transfer to VRAM
		pop	hl				; hl = Sprite Generator Table Screen 1
		ld	l,$20				; hl -> Sprite 1
		ld	a,$C0				; 2 points (expanded sprites)
		ld	bc,16				; 16 bytes 
		call	FILVRM				; Fill VRAM
		; --- COPY SPRITE DEFINITION TO VRAM ---

		call	INITSPRITES			; Show scores table and initialise SPRITES

MAIN:		; --- MAIN GAME ---
		halt					; Synchronization
		ld	a,[$F3E7]			; a = VDP(0)
		and	32				; Test 5th bit (sprite collision)
		call	nz,BATREBOUND			; Calculate new SPEED on bat rebound
		call	WALLREBOUND			; Check walls rebound
		call	CHECKGOAL			; Check goals
		call	MOVEBALL			; Move Ball and check Walls Change
		call	MOVEPLAYER1			; Check Player 1 Movement
		call	MOVEPLAYER2			; Check Player 2 Movement
		; --- PUT SPRITES ROUTINE ---
		ld	hl,SPRATT2			; SPRITES in RAM
		ld	de,[$F3C3]			; Sprite Attribute Table Screen 1
		ld	bc,12				; 12 bytes length
		call	LDIRVM				; Transfer to VRAM
		; --- PUT SPRITES ROUTINE ---
		call	RAM2VRAM			; Transfer BOARD to VRAM
		; --- CHECK ESC KEY ---
		ld	a,7				; 7th line of keyboard matrix
		call	SNSMAT				; Read line
		and	4				; Check ESC key (bit 2 of 7th line)
		jr	nz,MAIN				; goto MAIN if ESC not pressed
		jp	INITXT				; Screen 0 and RETURN FROM GAME
		; --- CHECK ESC KEY ---

BATREBOUND:	; --- BAT REBOUND ROUTINE ---
		call	SOUND1				; Bat Rebound Sound Effect
		ld	a,[BALLX+1]			; a = BALLX (integer part)
		cp	128				; if ( a >= 128 ) then...
		push	af				; Store flag values (*1)
		jr	nc,@@BAT2			; ...goto @@BAT2
		ld	a,[SPRATT2+4]			; a = BATY (player 1)
		jr	@@NEXT				; goto @@NEXT
@@BAT2:		ld	a,[SPRATT2+8]			; a = BATY (player 2)
@@NEXT:		ld	b,a				; Store a
		ld	a,[BALLY+1]			; a = BALLY (integer part)
		sub	b				; a = BALLY-BATY (-8 to 32)
		add	8				; Normalized value (0 to 40)
		and	$FE				; Even value
		cp	20				; if ( a < 20 ) then...
		push	af				; Store flag values (*2)
		jr	c,@@OK				; ... goto @@OK
		neg					; a = - a
		add	40				; a = 40 - a
@@OK:		ld	d,0				; d = 0
		ld	hl,ANGLE_TABLE			; Angle table address
		ld	e,a				; de = a
		add	hl,de				; Correct angle
		ld	e,[hl]				; de = |new ADDY|
		inc	hl				; Horizontal component
		ld	c,[hl]				; c = |new ADDX|
		call	BALLSPEED			; de = adjusted Ball Speed according level
		pop	af				; Restore flag values (*2)
		jr	nc,@@POSITIVEY			; if ( a >= 20 ) then goto @@POSITIVEY
		call	NEGDE				; hl = -de (negative vertical speed)
		jr	@@CHECKHS			; goto @@CHECKHS
@@POSITIVEY:	ex	de,hl				; de <-> hl
@@CHECKHS:	ld	[ADDY],hl			; Vertical speed stored
		ld	e,c				; e = |new ADDX|
		ld	d,0				; de = |new ADDY|
		call	BALLSPEED			; de = adjusted Ball Speed according level
		pop	af				; Restore flag values (*1)
		jr	c,@@POSITIVEX			; if ( a < 128 ) then goto @@POSITIVEX (bat1 to bat2)
		call	NEGDE				; hl = -de (negative horizontal speed)
		jr	@@ADJUST			; goto @@ADJUST
@@POSITIVEX:	ex	de,hl				; de <-> hl
@@ADJUST:	ld	[ADDX],hl			; Horizontal speed stored
		ld	hl,SPEEDLEVEL			; hl -> SPEEDLEVEL
		ld	a,8				; a = 8 (max level = 4)
		cp	[hl]				; if ( a = SPEEDLEVEL ) then...
		ret	z				; ...return
		inc	[hl]				; Increment SPEEDLEVEL
		ret					; Return
		; --- BAT REBOUND ROUTINE ---

BALLSPEED:	; --- ADJUST BALL SPEED ACCORDING LEVEL ---
		; --- DE = |SPEED| (in 8.8) ---
		ld	hl,SPEEDLEVEL			; hl -> speed level value
		ld	b,[hl]				; b = speed level (double than real speed)
		ld	hl,0				; hl = 0
		srl	e				; de = de div 2
@@ADD:		add	hl,de				; hl = hl + de
		djnz	@@ADD				; Close loop
		ex	de,hl				; de <-> hl
		ret					; Return
		; --- ADJUST BALL SPEED ACCORDING LEVEL ---

NEWADD:		; --- CALCULATES NEW SPEED AFTER WALL REBOUND ---
		; --- SIGN ( A ) = Correct direction ---
		; --- HL = SPEED ---
		or	a				; if ( a == 0 ) then...
		ret	z				; ...return
		xor	h				; a = a xor h
		and	128				; Sign bit
		ret	z				; if ( sign(a) == sgn(hl) ) then return
		; --- CALCULATES NEW SPEED AFTER WALL REBOUND ---
		
NEGHL:		; --- HL = -HL ---
		ex	de,hl				; de <-> hl
NEGDE:		; --- HL = -DE ---
		or	a				; UNSET Carry Flag (for a correct use of SBC)
		sbc	hl,hl				; hl = 0
		sbc	hl,de				; hl = -de (hl = -hl if first entry point used)
		ret					; Return
		; --- HL = -HL ---

GETCHAR:	; --- GETS CHAR IN THE GIVEN POINT ---
		; --- E = Ypos ---
		; --- D = Xpos ---
		ld	a,e				; a = Ypos
		and	$F8				; a = 8 * ( Ypos div 8 )
		ld	h,0				; h = 0
		ld	l,a				; hl = a
		add	hl,hl				; hl = hl * 2
		add	hl,hl				; hl = hl * 4 ( 32 * ( Ypos div 8 ) )
		; Adjust higher byte if point is outside visible screen
		ld	a,h				; a = h
		cp	3				; if ( a < 3 ) then...
		jr	c,@@NEXT			; ...goto @@NEXT
		xor	a				; a = 0
		ld	l,a				; l = 0
		; Adjust higher byte if point is outside visible screen
@@NEXT:		add	$C4				; Starting high byte of Screen in RAM
		ld	h,a				; hl -> first character in correct line
		ld	a,d				; a = Xpos
		srl	a				; a = Xpos div 2
		srl	a				; a = Xpos div 4
		srl	a				; a = Xpos div 8 (0 to 31)
		add	l				; a = a + l
		ld	l,a				; hl -> character
		ld	a,[hl]				; a = character value
		cp	3				; if ( a == 3 ) then...
		ret	z				; ...return (rebound character a <> 0)
		xor	a				; a = 0 (no rebound character)
		ret					; Return
		; --- GETS CHAR IN THE GIVEN POINT ---

MOVEPLAYER1:	; --- MOVE PLAYER ROUTINE ---
		ld	hl,SPRATT2+4			; hl -> BATY1
		xor	a				; a = 0 (STICK(0))
		call	@@CHECK				; call @@CHECK
		or	a				; if ( a <> 0 ) then...
		ret	nz				; ...return
		inc	a				; a = 1 (STICK(1))
		jr	@@CHECK				; goto @@CHECK
MOVEPLAYER2:	ld	a,2				; a = 2 (STICK(2))
		ld	hl,SPRATT2+8			; hl -> BATY2
@@CHECK:	push	hl				; Store hl
		call	GTSTCK				; Check Stick
		pop	hl				; Restore hl
		or	a				; if ( a == 0 ) then...
		ret	z				; ...return
		and	7				; (0=UpLeft ; 1=Up ; 2=UpRight)
		cp	3				; if ( a < 3 ) then...
		jr	c,@@UP				; ...goto @@UP
		sub	4				; (0=DownRight ; 1=Down ; 2=DownLeft)
		cp	3				; if ( a < 3 ) then...
		ret	nc				; ...return
@@DOWN:		ld	c,3				; DOWN routine -> c = 3 (8 bits)
		jr	@@MOVE				; goto @@MOVE
@@UP:		ld	c,253				; UP routine -> c = -3 (8 bits)
@@MOVE:		ld	a,[hl]				; a = CoordY Player Bat
		add	c				; a = New CoordY
		cp	4				; if ( a == 4 ) then...
		ret	z				; ...CoordY not actualized
		cp	154				; if ( a == 154 ) then...
		ret	z				; ...CoordY not actualized
		ld	[hl],a				; Store New BATY
		ret					; Return
		; --- MOVE PLAYER ROUTINE ---

MOVEBALL:	; --- MOVE BALL ROUTINE ---
		ld	hl,[BALLX]			; hl = BALLX (8.8)
		ld	de,[ADDX]			; de = ADDX (8.8)
		add	hl,de				; hl = new BALLX (8.8)
		ld	[BALLX],hl			; New BALLX (8.8) stored
		ld	a,h				; a = New BALLX (integer component
		ld	[SPRATT2+1],a			; BALLX coordinate in SPRATT2 section
		ld	c,a				; c = a
		ld	hl,[BALLY]			; hl = BALLY (8.8)
		ld	de,[ADDY]			; de = ADDY (8.8)
		add	hl,de				; hl = New BALLY (8.8)
		ld	a,h				; a = New BALLY (integer component)
		add	8				; a = a + 8
		cp	200				; if ( -8 < new BALLY < 192 ) then...
		jr	c,@@BY				; ...goto @@BY (ball is inside screen)
		push	af				; Store AF
		ld	a,d				; a = ADDY (integer component)
		cp	128				; if ( a >= 128 ) then...
		jr	nc,@@BALLUP			; ...goto @@BALLUP
@@BALLDOWN:	pop	af				; Restore AF
		sub	144				; Adjust BALLY when ball goes down (144 + 56 points down)
		push	af				; Store AF (shorter than a relative jump)
@@BALLUP:	pop	af				; Restore AF
		sub	56				; Adjust BALLY when ball goes up (56 points down)
@@BY:		sub	8				; Adjust BALLY
		ld	h,a				; hl = New BALLY (adjusted)
		ld	[BALLY],hl			; New BALLY (8.8) stored
		ld	[SPRATT2],a			; BALLY coordinate in SPRATT2 section
		sub	7				; a = a - Lower Y coordinate (7)
		cp	169				; if ( BALLY < 7 ) OR ( BALLY >= 176 ) then...
		ret	nc				; ...return
		ld	a,c				; a = BALLX
		sub	16				; a = a - Lower X coordinate (16)
		cp	217				; if ( BALLX < 16 ) OR ( BALLX >= 233 ) then...
		ret	nc				; ...return
		; --- MOVE BALL ROUTINE ---

RANDOM:		; --- RANDOM WALL CHANGE ---
		ld	hl,WALLCHANGE			; hl -> WALLCHANGE counter
		xor	a				; a = 0
		or	[hl]				; if ( counter == 0 ) then...
		jr	z,@@RND				; ...goto @@RND
		dec	[hl]				; Decrement counter
		ret					; Return
@@RND:		push	hl				; Save hl
		call	CHKTRG				; Check Triggers
		pop	hl				; Restore hl
		ret	z				; No trigs -> walls remain unchanged
		ld	[hl],WALLTIME			; No changes in WALLTIME vblanks
		ld	a,r				; Random number
		ld	c,a				; Store Random number
		and	3				; Select wall (0-3)
		jr	nz,@@NEXT			; if ( a == 0 ) then...
		inc	a				; ...a = 1
@@NEXT:		ld	b,a				; Store wall
		ld	a,c				; Retrieve Random number
		rrca					; a = a div 2
		rrca					; a = a div 2
		and	7				; Select wall mode (0-7)
		; --- RANDOM WALL CHANGE ---

DRAWALL:	; --- Draws a wall in RAM ---
		; --- A = pattern of the wall (0 to 7) ---
		; --- B = number of the wall (1, 2 or 3)
		ld	d,0				; d = 0
		ld	e,a				; de = a
		ld	hl,WALLS			; hl -> walls patterns
		add	hl,de				; hl = hl + de
		add	hl,de				; hl = hl + de * 2
		add	hl,de				; hl -> selected pattern wall mode
		push	hl				; Store hl
		pop	IX				; Retrieve IX ( IX = hl )
		ld	hl,RAMBUFFER+$0001		; hl -> RAMBUFFER+1 (wall 2 address)
		ld	a,b				; a = wall
		ld	e,1				; Increment of walls 0 and 1
		dec	a				; a = wall - 1
		jr	z,@@WALL1			; goto @@WALL1
		ld	e,32				; increment of walls 2 and 3
		dec	a				; a = wall - 2
		jr	z,@@DRAW			; goto @@DRAW
@@WALL3:	ld	l,$1E				; hl -> starting address of wall 3 (right wall)
		jr	@@DRAW				; goto @@DRAW
@@WALL1:	push	IX				; Save IX value
		ld	l,$04				; hl -> starting address of wall 0 (upper wall)
		call	@@DRAW				; Call @@DRAW routine to show upper wall
		pop	IX				; Restore IX value
		ld	hl,RAMBUFFER+$02E4		; hl -> starting address of wall 1 (lower wall)
@@DRAW:		call	BITS2RAM			; Draw first byte
		inc	IX				; Increment pointer
		call	BITS2RAM			; Draw second byte
		inc	IX				; Increment pointer (no return to draw last byte)
		; --- Draws a wall in RAM ---

BITS2RAM:	; --- Copy 8 bits of a byte to 8 bytes in RAM ---
		; --- IX = Pointer to byte ---
		; --- HL = Start destination ---
		; --- DE = Increment ---
		ld	b,8				; 8 bits / byte
		ld	a,[IX]				; Get byte
@@LOOP:		rlca					; Rotate left
		jr	c,@@PUT1			; if ( carry ) goto @@PUT1
@@PUT0:		ld	[hl],0				; no carry -> write 0
		jr	@@ENDB				; goto @@ENDB
@@PUT1:		ld	[hl],3				; carry -> write 3
@@ENDB:		add	hl,de				; Increment hl
		djnz	@@LOOP				; Close loop
		ret					; Return
		; --- Copy a byte to 8 bytes in RAM ---

SHOWSCORES:	; --- Shows Score table ---
		ld	a,[SCP1]			; a = Score Player 1
		ld	hl,RAMBUFFER+$0045		; Origin
		call	PUTBIGCHAR			; Show Score Player 1
		ld	a,[SCP2]			; a = Score Player 2
		ld	hl,RAMBUFFER+$0056		; Origin
		call	PUTBIGCHAR			; Show Score Player 2
		call	RAM2VRAM			; Show Screen
@@LOOP:		call	WAITTRIG			; Wait triggers
		ld	hl,RAMBUFFER+$0045		; Origin
		call	PUTBIGCHAR			; Clear score player 1
		xor	a				; a = 0
		ld	hl,RAMBUFFER+$0056		; Origin... and clear score player 2
		; --- Shows Score table ---

PUTBIGCHAR:	; --- Puts a BIG char in RAM ---
		; --- A = Character ---
		; --- HL = Destination ---
		push	hl				; Store destination
		ld	de,[$F920]			; de -> Character definition
		ld	h,0				; h = 0
		ld	l,a				; hl = a
		add	hl,hl				; hl = hl * 2
		add	hl,hl				; hl = hl * 4
		add	hl,hl				; hl = hl * 8 (character * 8)
		add	hl,de				; hl -> character definition
		push	hl				; Store pointer to character definition
		pop	IX				; Retrieve pointer to character definition
		pop	hl				; Retrieve destination
		ld	b,8				; 8 bytes to transfer
@@LOOP:		ld	c,b				; Store counter
		ld	de,1				; Increment = 1
		call	BITS2RAM			; Transfer byte to ram
		inc	IX				; Increment pointer to next byte
		ld	e,24				; de = 24
		add	hl,de				; Add 24 bytes to destination
		ld	b,c				; Restore counter
		djnz	@@LOOP				; Close loop
		ret					; Return
		; --- Puts a BIG char in RAM ---

PUTBIGTEXT:	; --- Puts a BIG text in RAM ---
		; --- IY = Pointer to text ---
		; --- HL = Start Destination ---
@@LOOP:		ld	a,[IY]				; Character
		or	a				; if ( a == 0 ) then...
		ret	z				; ...return
@@BIGCHAR:	call	PUTBIGCHAR			; Copy big character in ram
		ld	de,-250				; Increment (+6 bytes - 256 bytes from PUTBIGCHAR)
		add	hl,de				; Increment destination
@@NEXT:		inc	IY				; Increment pointer
		jr	@@LOOP				; Close loop
		; --- Puts a BIG text in RAM ---

RAM2VRAM:	; --- Copy BOARD from RAM to VRAM ---
		; --- No Parameters needed ---
		ld	hl,RAMBUFFER+$0000		; SCREEN in RAM
		ld	de,[$F3BD]			; Pattern Name Table Screen 1
		ld	bc,768				; 768 bytes
		jp	LDIRVM				; Transfer to VRAM
		; --- Copy BOARD from RAM to VRAM ---

CLEARRAM:	; --- Clear RAM ---
		; --- No Parameters needed ---
		call	CLRSPR				; First clear Sprites
		ld	hl,RAMBUFFER+$0000		; Origin
		xor	a				; Fill with 0
		ld	bc,767				; Length... and fill RAM
		; --- Clear RAM ---

FILLRAM:	; --- FILL RAM ---
		; --- A = Value to fill ---
		; --- HL = Origin ---
		; --- BC = Length ( -1 ) ---
		ld	[hl],a				; Write a
		ld	d,h				; d = h
		ld	e,l				; de = hl
		inc	de				; de = hl + 1
		ldir					; Copy
		ret					; Return
		; --- FILL RAM ---

INITSPRITES:	call	SHOWSCORES			; Everytime we initialize sprites, first show scores
		; --- SET INITIAL ATTRIBUTES ---
		ld	hl,SPRATT			; Initial settings
		ld	de,BALLX			; Work zone
		ld	bc,22				; Length (3 sprites + speed level + WALLCHANGE + coord/speed in 8.8)
		ldir					; Transfer
		; --- SET BALL INITIAL SPEED ---
		ld	a,r				; Random number
		and	1				; Just 1 or 0
		rla					; a = a * 2 (1 -> 2 and 0 -> 0)
		dec	a				; a = a - 1 (1 -> 1 and 0 -> -1)
		ld	[ADDX+1],a			; Initial horizontal speed set

CHKTRG:		; --- Check Triggers Routine ---
		; --- No Parameters Needed ---
		xor	a				; a = 0
		call	GTTRIG				; Check trigger(0)
		ret	nz				; Return if trigger(0) is pushed
		inc	a				; a = 1
		call	GTTRIG				; Check trigger(1)
		ret	nz				; Return if trigger(1) is pushed
		ld	a,2				; a = 2
		jp	GTTRIG				; Check trigger(2)
		; --- Check Triggers Routine ---

WAITTRIG:	; --- WAITS UNTIL TRIGGER PRESSED ---
		call	NOTRIG				; Wait until no triggers pressed
@@LOOP:		call	CHKTRG				; Check triggers
		jr	z,@@LOOP			; Close loop
		; --- WAITS UNTIL TRIGGER PRESSED ---

NOTRIG:		; --- WAITS UNTIL NO TRIGGER PRESSED ---
		call	CHKTRG				; Checks Triggers
		jr	nz,NOTRIG			; While pressed goto NOTRIG
		ret					; Return
		; --- WAITS UNTIL NO TRIGGER PRESSED ---

		; --- TEXTS --- TEXTS --- TEXTS ---
TEXT1:		.db	"1P",0				; 1P / 2P
TEXT2:		.db	"WINS"				; WINS (end string value <- first value of BALLX)

		; --- DATA --- DATA --- DATA ---
SPRATT:		.db	0,124,0,91			; Ball coordinates in 8.8
		.db	91,124,0,12			; Ball Centered position
		.db	79,BATX1,4,4			; Bat player 1
		.db	79,BATX2,4,6			; Bat player 2
		.db	2,WALLTIME			; Initial speed level, Wallchange initial value
GRAPHICSC:	.db	$00,$00,$00,$00,$00,$00,$00,$00	; Character 0, transparent (first 4 bytes initial settings too)
		.db	$00,$00,$00,$01,$01,$00,$00,$00	; Character 1, center line (left)
		.db	$00,$00,$00,$80,$80,$00,$00,$00 ; Character 2, center line (right)
		.db	$FF,$FF,$FF,$FF,$FF		; Character 3, filled
WALLS:		.db	$FF,$FF,$FF			; WALL 0 (also last 3 bytes of character 3)
		.db	$80,$00,$01			; WALL 1
		.db	$F0,$00,$0F			; WALL 2
		.db	$FF,$00,$FF			; WALL 3
		.db	$C0,$3C,$03			; WALL 4
		.db	$F8,$42,$1F			; WALL 5
		.db	$CC,$C3,$33			; WALL 6
		.db	$CC,$81,$33			; WALL 7
GRAPHICSS:	.db	$60,$F0,$F0,$60			; BALL

ANGLE_TABLE:	.db	$EE,$57		;  0 - 40
		.db	$E1,$75		;  2 - 38
		.db	$CC,$94		;  4 - 36
		.db	$B5,$B0		;  6 - 34
		.db	$9C,$C7		;  8 - 32
		.db	$7D,$DC		; 10 - 30
		.db	$5E,$EB		; 12 - 28
		.db	$3A,$F8		; 14 - 26
		.db	$19,$FD		; 16 - 24
		.db	$08,$FE 	; 18 - 22
		.db	$00,$FF		; 20 - 20
