; 2011.11.05 KdL
; ---------------------------------------------------------------
; V-Editor MSX1 da 8,7 pagine (8 pagine 32x22 + 14 righe)
; ---------------------------------------------------------------
;
; BLOAD"V1EDITOR.BIN",R
;
; USR7(n) <n> da 0 a 8, numero di pagina per SAVE TXT in VRAM
; USR8(n) <n> da 0 a 8, numero di pagina per LOAD TXT in VRAM
; USR9(y) da 0 a 168 per scorrere in verticale
;
; BSAVE"DATA.VRM",8256,14335,S -> salva tutta la VRAM libera
; BLOAD"DATA.VRM",S -> carica la VRAM
;
; Attenzione! Usare l'ultima pagina con molta cautela:
; le ultime 7 righe sono utilizzate per visualizzare gli sprite.
;
; ---------------------------------------------------------------


  .org 0e000h-7

  .byte 254
  .word start
  .word end
  .word init

start:

init:
  ld hl,tobuf
  ld (0f3a8h),hl
  ld hl,frombuf
  ld (0f3aah),hl
  ld hl,frombufy
  ld (0f3ach),hl
  ret

getpar:
  ld a,(0f663h)
  cp 2
  jr nz,gpret
  ld hl,(0f7f8h)
  ret
gpret:
  pop af
  ret

frombufy:
  call getpar
  add hl,hl
  add hl,hl
  add hl,hl
  add hl,hl
  add hl,hl
  jr fbhop

frombuf:
  call getpar
  add hl,hl
  add hl,hl
  add hl,hl
  add hl,hl
  add hl,hl
  ld (buffer),hl
  ld b,21
x22_floop:
  ld de,(buffer)
  add hl,de
  djnz x22_floop
  
fbhop:
  ld de,8192+64             ; CT Base + CT Width (CT=Color Table)
  add hl,de
  ld (readadr),hl
  ld hl,6144+64
  ld (writeadr),hl

copyfrom:
  ld bc,22*256+152
  di
floopy:
  push bc
  ld hl,(readadr)
  call setvramread
  ld de,32
  add hl,de
  ld (readadr),hl
  ld hl,buffer
  ld b,32
finloop:
  ini
  jr nz,finloop
  ld hl,(writeadr)
  call setvramwrite
  ld de,32
  add hl,de
  ld (writeadr),hl
  ld hl,buffer
  ld b,32
foutloop:
  outi
  jr nz,foutloop
  pop bc
  djnz floopy
  ei
  ret

tobuf:
  call getpar
  add hl,hl
  add hl,hl
  add hl,hl
  add hl,hl
  add hl,hl
  ld (buffer),hl
  ld b,21
x22_tloop:
  ld de,(buffer)
  add hl,de
  djnz x22_tloop
  ld de,8192+64             ; CT Base + CT Width (CT=Color Table)
  add hl,de
  ld (writeadr),hl
  ld hl,6144+64
  ld (readadr),hl

copyto:
  ld bc,22*256+152
  di
tloopy:
  push bc
  ld hl,(readadr)
  call setvramread
  ld de,32
  add hl,de
  ld (readadr),hl
  ld hl,buffer
  ld b,32
tinloop:
  ini
  jr nz,tinloop
  ld hl,(writeadr)
  call setvramwrite
  ld de,32
  add hl,de
  ld (writeadr),hl
  ld hl,buffer
  ld b,32
toutloop:
  outi
  jr nz,toutloop
  pop bc
  djnz tloopy
  ei
  ret

setvramread:
  ld a,l
  out (99h),a
  ld a,h
  and 63
  out (99h),a
  ret

setvramwrite:
  ld a,l
  out (99h),a
  ld a,h
  or 64
  and 127
  out (99h),a
  ret

readadr:
  .word 0
writeadr:
  .word 0
buffer:
  .ds 32

end:

.end
