	;; -------------------------------------------------------------------
	;; Snowclimber
	;; -------------------------------------------------------------------
	;; This file contains displays the title screen and handles the menu
	;; selection.
	;; -------------------------------------------------------------------

title_1p:   equ 12
title_2p:   equ 14
title_exit: equ 16

title_main:

	;;-------------------------------
	;; display title screen
	;;-------------------------------

 	call init32
	call bold_font

	ld   hl,pinguin_pattern
	ld   de,$0400	; 128*8
	ld   bc,$0300
	call ldirmv

	ld   hl,pinguin_names
	ld   de,$1840	; $1800+64
	ld   bc,$0280
	call ldirmv	

	;;-------------------------------
	;; wait for fire and exit
	;;-------------------------------

	ld   bc,20*256+12
_menu_loop:
	xor  a
	push bc
	
	ld   [csry],bc
	ld   a,' '
	call chput
    
	xor  a
	call gttrig
	pop  bc
	and  a
	ret  nz          ; menu option returned in c

	push bc
	ld   a,1
	call gttrig
	pop  bc
	and  a
	ret  nz
	    
	push bc
	call gtstck
	ld   c,a
	ld   a,1
	call gtstck
	or   c
	pop  bc
	
	or   a
	jr   z,_menu_movedone	
	and  4
	ld   a,c
	jr   nz,_menu_down
	cp   12
	jr   z,_menu_movedone
	dec  c
	dec  c
	jr   _menu_movedone
_menu_down:
	cp   16
	jr   z,_menu_movedone
	inc  c
	inc  c
_menu_movedone:
	ld  (csry),bc
	ld   a,'>'
	call chput
    
	ld   a,8
	call delay
	
	jr   _menu_loop
	
	
	;; -------------------------------------------------------------------
	;; pinguin image data
	;; -------------------------------------------------------------------

pinguin_pattern:
	db $ff, $ff, $ff, $ff, $ff, $ff, $ff, $ff
	db $00, $01, $04, $01, $14, $02, $28, $71
	db $28, $45, $98, $35, $a8, $52, $a8, $40
	db $00, $00, $00, $00, $48, $00, $15, $25
	db $00, $00, $00, $00, $03, $59, $d6, $50
	db $00, $00, $14, $a0, $40, $00, $40, $00
	db $00, $01, $00, $01, $03, $03, $03, $03
	db $f2, $f8, $f8, $f1, $f0, $e0, $e1, $c8
	db $11, $44, $01, $12, $00, $00, $00, $20
	db $45, $12, $40, $00, $00, $00, $00, $00
	db $07, $01, $05, $0b, $05, $0b, $05, $0f
	db $c0, $c0, $69, $a0, $5a, $e9, $56, $e9
	db $00, $00, $00, $42, $10, $4d, $96, $7f
	db $00, $00, $00, $40, $80, $50, $a8, $d0
	db $05, $0e, $05, $0b, $0a, $0d, $02, $0c
	db $2a, $d7, $ab, $5f, $bf, $7f, $ff, $ff
	db $fe, $d3, $fd, $ff, $ff, $ff, $ff, $ff
	db $00, $80, $60, $d0, $68, $f0, $fc, $fc
	db $11, $1b, $23, $57, $27, $97, $4f, $4f
	db $ea, $fc, $ff, $fd, $f7, $fd, $ff, $fd
	db $00, $00, $04, $00, $03, $04, $0b, $03
	db $9f, $9f, $4f, $9f, $1f, $9f, $5f, $9f
	db $40, $40, $c0, $60, $d0, $60, $b0, $c8
	db $0f, $07, $1b, $07, $0f, $13, $0b, $24
	db $1f, $5f, $1f, $9f, $3f, $3f, $bf, $3f
	db $b0, $68, $d4, $68, $d4, $68, $b4, $ea
	db $08, $23, $00, $13, $00, $44, $13, $00
	db $54, $b4, $d5, $aa, $7a, $a5, $da, $74
	db $00, $00, $00, $00, $40, $00, $50, $88
	db $00, $00, $01, $00, $01, $04, $02, $01
	db $28, $03, $50, $03, $73, $83, $a7, $53
	db $d5, $6a, $b5, $da, $75, $d4, $7a, $d5
	db $12, $44, $21, $8a, $14, $a2, $09, $a4
	db $00, $00, $40, $34, $c2, $39, $8d, $72
	db $00, $00, $00, $00, $80, $20, $90, $d4
	db $17, $0d, $36, $5b, $5f, $f4, $ba, $d6
	db $87, $47, $af, $07, $0f, $07, $0f, $0f
	db $ff, $fb, $fe, $ff, $fb, $fe, $ff, $f7
	db $6a, $da, $ed, $b5, $ea, $ba, $d5, $fa
	db $01, $aa, $00, $4a, $90, $05, $a0, $01
	db $46, $b9, $0e, $b1, $37, $48, $06, $49
	db $aa, $7a, $ad, $da, $35, $de, $53, $ad
	db $00, $80, $00, $c0, $b0, $d0, $68, $bc
	db $01, $07, $03, $0d, $0b, $0e, $13, $0d
	db $ec, $58, $e8, $58, $f0, $80, $70, $c0
	db $0f, $0f, $0f, $0f, $0f, $1f, $1f, $1f
	db $fd, $ff, $ff, $f6, $ff, $fd, $f7, $fe
	db $56, $f5, $aa, $fd, $d2, $ad, $f4, $ab
	db $a4, $00, $a0, $40, $00, $80, $40, $80
	db $32, $05, $08, $02, $04, $01, $00, $02
	db $2b, $aa, $97, $55, $ab, $16, $a3, $15
	db $6a, $dc, $6b, $be, $75, $df, $6a, $bf
	db $00, $00, $00, $80, $40, $80, $c0, $a0
	db $5a, $2f, $b2, $4d, $ba, $54, $d6, $a8
	db $1f, $3f, $1f, $3f, $3f, $3f, $3f, $3f
	db $ff, $fd, $f7, $ff, $fd, $ff, $ef, $fb
	db $fa, $aa, $d5, $7a, $ea, $55, $fa, $55
	db $00, $a0, $00, $a0, $40, $00, $a0, $40
	db $49, $02, $12, $01, $00, $05, $00, $00
	db $75, $ae, $d7, $29, $57, $55, $2a, $15
	db $60, $a0, $70, $ac, $68, $b4, $d4, $aa
	db $05, $01, $12, $09, $13, $02, $25, $12
	db $54, $a8, $b0, $50, $50, $a0, $50, $a0
	db $7f, $3f, $7f, $3f, $7f, $3f, $7f, $3f
	db $f5, $aa, $f5, $5a, $f5, $5a, $ed, $da
	db $74, $8d, $64, $15, $02, $08, $05, $02
	db $05, $2a, $0d, $52, $05, $5a, $0a, $25
	db $40, $80, $40, $80, $00, $80, $00, $00
	db $ba, $ed, $75, $da, $f5, $ad, $f6, $dd
	db $80, $50, $00, $a0, $40, $00, $a0, $40
	db $4a, $10, $4a, $24, $40, $54, $00, $a0
	db $3f, $3f, $3f, $1f, $3f, $1f, $1f, $1f
	db $ba, $ed, $b6, $fd, $75, $da, $ed, $f6
	db $80, $40, $80, $20, $40, $40, $00, $a0
	db $1f, $1f, $1f, $0f, $1f, $0f, $0f, $0f
	db $fe, $fe, $ff, $ff, $df, $fe, $ff, $f7
	db $bd, $bd, $ea, $fd, $aa, $f6, $d9, $6c
	db $07, $07, $07, $07, $03, $03, $00, $00
	db $ff, $fe, $fb, $de, $fb, $d6, $69, $2a
	db $bf, $fd, $db, $ff, $b5, $6d, $da, $6a
	db $fa, $a4, $6a, $b1, $4c, $50, $84, $50
	db $7f, $7f, $7f, $3f, $1f, $3e, $1f, $1e
	db $ff, $ff, $f5, $da, $f5, $aa, $d4, $aa
	db $ea, $5a, $a5, $94, $22, $48, $81, $10
	db $d4, $a1, $14, $80, $55, $00, $2a, $84
	db $94, $69, $90, $4a, $20, $42, $94, $40
	db $0f, $0f, $0e, $0e, $0f, $0e, $05, $06
	db $d4, $a9, $90, $82, $50, $00, $40, $08
	db $12, $04, $01, $08, $00, $00, $02, $00
	db $94, $20, $08, $40, $00, $10, $40, $00
	db $01, $02, $01, $02, $00, $01, $02, $01
	db $40, $00, $48, $02, $a8, $01, $d4, $22
	db $00, $00, $02, $00, $05, $00, $05, $00
	db $20, $80, $20, $90, $60, $80, $28, $80
	
pinguin_names:
	;;   length: 300
	db $00,$00,$00,$00,$00,$81,$82,$83,$84,$85,$00,$00,$00,$00,$00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db $00,$00,$00,$00,$86,$87,$88,$89,$00,$00,$00,$00,$00,$00,$00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db $00,$00,$00,$00,$8a,$8b,$8c,$8d,$00,$00,$00,$00,$00,$00,$00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db $00,$00,$00,$00,$8e,$8f,$80,$90,$91,$00,$00,$00,"SNOWCLIMBER 2K",0,0,0,0,0,0
	db $00,$00,$00,$00,$92,$80,$80,$80,$93,$00,$00,$00,$00,$00,$00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db $00,$00,$00,$94,$95,$80,$80,$80,$80,$96,$00,$00,$00,$00,$00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db $00,$00,$00,$97,$98,$80,$80,$80,$80,$99,$00,$00,$00,$00,$00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db $00,$00,$00,$9a,$80,$80,$80,$80,$80,$9b,$9c,$00,$00,$00,$00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db $00,$00,$9d,$9e,$80,$80,$80,$80,$80,$9f,$a0,$a1,$a2,$00,$00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db $00,$00,$a3,$a4,$80,$80,$80,$80,$a5,$a6,$a7,$a8,$a9,$aa,$00,0,0,0,0,0,0,"1 PLAYER",0,0,0
	db $00,$ab,$ac,$ad,$80,$80,$80,$80,$ae,$af,$b0,$b1,$b2,$b3,$b4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db $00,$b5,$00,$b6,$80,$80,$80,$80,$b7,$b8,$b9,$00,$ba,$bb,$bc,0,0,0,0,0,0,"2 PLAYER",0,0,0
	db $bd,$be,$00,$bf,$80,$80,$80,$80,$80,$c0,$b9,$00,$00,$00,$c1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db $c2,$c3,$00,$b6,$80,$80,$80,$80,$80,$c4,$c5,$00,$00,$00,$00,0,0,0,0,0,0,"EXIT",0,0,0,0,0,0,0
	db $c6,$00,$00,$c7,$80,$80,$80,$80,$80,$c8,$c9,$00,$00,$00,$00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db $00,$00,$00,$ca,$80,$80,$80,$80,$cb,$cc,$00,$00,$00,$00,$00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db $00,$00,$00,$cd,$80,$80,$80,$ce,$cf,$d0,$00,$00,$00,$00,$00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db $00,$00,$00,$00,$d1,$d2,$d3,$d4,$d5,$00,$00,$00,$00,$00,$00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db $00,$00,$00,$00,$d6,$d7,$00,$d8,$d9,$00,$00,$00,$00,$00,$00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db $00,$00,$00,$00,$da,$db,$00,$dc,$dd,$00,0,0,0,0,0,0,0,0,0,"dvik & joyrex"
